package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReservedInstancesId(
    reservedInstancesId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ReservedInstancesId = {
    import ReservedInstancesId.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ReservedInstancesId
      .builder()
      .optionallyWith(
        reservedInstancesId.map(value => value: java.lang.String)
      )(_.reservedInstancesId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ReservedInstancesId.ReadOnly =
    zio.aws.ec2.model.ReservedInstancesId.wrap(buildAwsValue())
}
object ReservedInstancesId {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ReservedInstancesId
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ReservedInstancesId = zio.aws.ec2.model
      .ReservedInstancesId(reservedInstancesId.map(value => value))
    def reservedInstancesId: Optional[String]
    def getReservedInstancesId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reservedInstancesId", reservedInstancesId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ReservedInstancesId
  ) extends zio.aws.ec2.model.ReservedInstancesId.ReadOnly {
    override val reservedInstancesId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reservedInstancesId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ReservedInstancesId
  ): zio.aws.ec2.model.ReservedInstancesId.ReadOnly = new Wrapper(impl)
}
