package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RegisterInstanceEventNotificationAttributesRequest(
    instanceTagAttribute: zio.aws.ec2.model.RegisterInstanceTagAttributeRequest
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RegisterInstanceEventNotificationAttributesRequest = {
    import RegisterInstanceEventNotificationAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RegisterInstanceEventNotificationAttributesRequest
      .builder()
      .instanceTagAttribute(instanceTagAttribute.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.RegisterInstanceEventNotificationAttributesRequest.ReadOnly =
    zio.aws.ec2.model.RegisterInstanceEventNotificationAttributesRequest
      .wrap(buildAwsValue())
}
object RegisterInstanceEventNotificationAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RegisterInstanceEventNotificationAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.RegisterInstanceEventNotificationAttributesRequest =
      zio.aws.ec2.model.RegisterInstanceEventNotificationAttributesRequest(
        instanceTagAttribute.asEditable
      )
    def instanceTagAttribute
        : zio.aws.ec2.model.RegisterInstanceTagAttributeRequest.ReadOnly
    def getInstanceTagAttribute: ZIO[
      Any,
      Nothing,
      zio.aws.ec2.model.RegisterInstanceTagAttributeRequest.ReadOnly
    ] = ZIO.succeed(instanceTagAttribute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RegisterInstanceEventNotificationAttributesRequest
  ) extends zio.aws.ec2.model.RegisterInstanceEventNotificationAttributesRequest.ReadOnly {
    override val instanceTagAttribute
        : zio.aws.ec2.model.RegisterInstanceTagAttributeRequest.ReadOnly =
      zio.aws.ec2.model.RegisterInstanceTagAttributeRequest
        .wrap(impl.instanceTagAttribute())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RegisterInstanceEventNotificationAttributesRequest
  ): zio.aws.ec2.model.RegisterInstanceEventNotificationAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
