package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait OfferingClassType {
  def unwrap: software.amazon.awssdk.services.ec2.model.OfferingClassType
}
object OfferingClassType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.OfferingClassType
  ): zio.aws.ec2.model.OfferingClassType = value match {
    case software.amazon.awssdk.services.ec2.model.OfferingClassType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.OfferingClassType.STANDARD =>
      val r = standard
      r
    case software.amazon.awssdk.services.ec2.model.OfferingClassType.CONVERTIBLE =>
      val r = convertible
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.OfferingClassType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.OfferingClassType =
      software.amazon.awssdk.services.ec2.model.OfferingClassType.UNKNOWN_TO_SDK_VERSION
  }
  case object standard extends zio.aws.ec2.model.OfferingClassType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.OfferingClassType =
      software.amazon.awssdk.services.ec2.model.OfferingClassType.STANDARD
  }
  case object convertible extends zio.aws.ec2.model.OfferingClassType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.OfferingClassType =
      software.amazon.awssdk.services.ec2.model.OfferingClassType.CONVERTIBLE
  }
}
