package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait LocalGatewayRouteType {
  def unwrap: software.amazon.awssdk.services.ec2.model.LocalGatewayRouteType
}
object LocalGatewayRouteType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.LocalGatewayRouteType
  ): zio.aws.ec2.model.LocalGatewayRouteType = value match {
    case software.amazon.awssdk.services.ec2.model.LocalGatewayRouteType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.LocalGatewayRouteType.STATIC =>
      val r = static
      r
    case software.amazon.awssdk.services.ec2.model.LocalGatewayRouteType.PROPAGATED =>
      val r = propagated
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.LocalGatewayRouteType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LocalGatewayRouteType =
      software.amazon.awssdk.services.ec2.model.LocalGatewayRouteType.UNKNOWN_TO_SDK_VERSION
  }
  case object static extends zio.aws.ec2.model.LocalGatewayRouteType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LocalGatewayRouteType =
      software.amazon.awssdk.services.ec2.model.LocalGatewayRouteType.STATIC
  }
  case object propagated extends zio.aws.ec2.model.LocalGatewayRouteType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LocalGatewayRouteType =
      software.amazon.awssdk.services.ec2.model.LocalGatewayRouteType.PROPAGATED
  }
}
