package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  SubnetId,
  NetworkInterfaceId,
  LocalGatewayVirtualInterfaceGroupId,
  LocalGatewayRoutetableId,
  CoipPoolId,
  ResourceArn,
  PrefixListResourceId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LocalGatewayRoute(
    destinationCidrBlock: Optional[String] = Optional.Absent,
    localGatewayVirtualInterfaceGroupId: Optional[
      LocalGatewayVirtualInterfaceGroupId
    ] = Optional.Absent,
    `type`: Optional[zio.aws.ec2.model.LocalGatewayRouteType] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.LocalGatewayRouteState] = Optional.Absent,
    localGatewayRouteTableId: Optional[LocalGatewayRoutetableId] =
      Optional.Absent,
    localGatewayRouteTableArn: Optional[ResourceArn] = Optional.Absent,
    ownerId: Optional[String] = Optional.Absent,
    subnetId: Optional[SubnetId] = Optional.Absent,
    coipPoolId: Optional[CoipPoolId] = Optional.Absent,
    networkInterfaceId: Optional[NetworkInterfaceId] = Optional.Absent,
    destinationPrefixListId: Optional[PrefixListResourceId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LocalGatewayRoute = {
    import LocalGatewayRoute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LocalGatewayRoute
      .builder()
      .optionallyWith(
        destinationCidrBlock.map(value => value: java.lang.String)
      )(_.destinationCidrBlock)
      .optionallyWith(
        localGatewayVirtualInterfaceGroupId.map(value =>
          LocalGatewayVirtualInterfaceGroupId.unwrap(value): java.lang.String
        )
      )(_.localGatewayVirtualInterfaceGroupId)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        localGatewayRouteTableId.map(value =>
          LocalGatewayRoutetableId.unwrap(value): java.lang.String
        )
      )(_.localGatewayRouteTableId)
      .optionallyWith(
        localGatewayRouteTableArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.localGatewayRouteTableArn)
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(
        subnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(
        coipPoolId.map(value => CoipPoolId.unwrap(value): java.lang.String)
      )(_.coipPoolId)
      .optionallyWith(
        networkInterfaceId.map(value =>
          NetworkInterfaceId.unwrap(value): java.lang.String
        )
      )(_.networkInterfaceId)
      .optionallyWith(
        destinationPrefixListId.map(value =>
          PrefixListResourceId.unwrap(value): java.lang.String
        )
      )(_.destinationPrefixListId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.LocalGatewayRoute.ReadOnly =
    zio.aws.ec2.model.LocalGatewayRoute.wrap(buildAwsValue())
}
object LocalGatewayRoute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LocalGatewayRoute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LocalGatewayRoute =
      zio.aws.ec2.model.LocalGatewayRoute(
        destinationCidrBlock.map(value => value),
        localGatewayVirtualInterfaceGroupId.map(value => value),
        `type`.map(value => value),
        state.map(value => value),
        localGatewayRouteTableId.map(value => value),
        localGatewayRouteTableArn.map(value => value),
        ownerId.map(value => value),
        subnetId.map(value => value),
        coipPoolId.map(value => value),
        networkInterfaceId.map(value => value),
        destinationPrefixListId.map(value => value)
      )
    def destinationCidrBlock: Optional[String]
    def localGatewayVirtualInterfaceGroupId
        : Optional[LocalGatewayVirtualInterfaceGroupId]
    def `type`: Optional[zio.aws.ec2.model.LocalGatewayRouteType]
    def state: Optional[zio.aws.ec2.model.LocalGatewayRouteState]
    def localGatewayRouteTableId: Optional[LocalGatewayRoutetableId]
    def localGatewayRouteTableArn: Optional[ResourceArn]
    def ownerId: Optional[String]
    def subnetId: Optional[SubnetId]
    def coipPoolId: Optional[CoipPoolId]
    def networkInterfaceId: Optional[NetworkInterfaceId]
    def destinationPrefixListId: Optional[PrefixListResourceId]
    def getDestinationCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destinationCidrBlock", destinationCidrBlock)
    def getLocalGatewayVirtualInterfaceGroupId
        : ZIO[Any, AwsError, LocalGatewayVirtualInterfaceGroupId] =
      AwsError.unwrapOptionField(
        "localGatewayVirtualInterfaceGroupId",
        localGatewayVirtualInterfaceGroupId
      )
    def getType: ZIO[Any, AwsError, zio.aws.ec2.model.LocalGatewayRouteType] =
      AwsError.unwrapOptionField("type", `type`)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.LocalGatewayRouteState] =
      AwsError.unwrapOptionField("state", state)
    def getLocalGatewayRouteTableId
        : ZIO[Any, AwsError, LocalGatewayRoutetableId] = AwsError
      .unwrapOptionField("localGatewayRouteTableId", localGatewayRouteTableId)
    def getLocalGatewayRouteTableArn: ZIO[Any, AwsError, ResourceArn] = AwsError
      .unwrapOptionField("localGatewayRouteTableArn", localGatewayRouteTableArn)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getCoipPoolId: ZIO[Any, AwsError, CoipPoolId] =
      AwsError.unwrapOptionField("coipPoolId", coipPoolId)
    def getNetworkInterfaceId: ZIO[Any, AwsError, NetworkInterfaceId] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getDestinationPrefixListId: ZIO[Any, AwsError, PrefixListResourceId] =
      AwsError.unwrapOptionField(
        "destinationPrefixListId",
        destinationPrefixListId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LocalGatewayRoute
  ) extends zio.aws.ec2.model.LocalGatewayRoute.ReadOnly {
    override val destinationCidrBlock: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationCidrBlock())
      .map(value => value: String)
    override val localGatewayVirtualInterfaceGroupId
        : Optional[LocalGatewayVirtualInterfaceGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.localGatewayVirtualInterfaceGroupId())
      .map(value =>
        zio.aws.ec2.model.primitives.LocalGatewayVirtualInterfaceGroupId(value)
      )
    override val `type`: Optional[zio.aws.ec2.model.LocalGatewayRouteType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.ec2.model.LocalGatewayRouteType.wrap(value))
    override val state: Optional[zio.aws.ec2.model.LocalGatewayRouteState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.LocalGatewayRouteState.wrap(value))
    override val localGatewayRouteTableId: Optional[LocalGatewayRoutetableId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localGatewayRouteTableId())
        .map(value =>
          zio.aws.ec2.model.primitives.LocalGatewayRoutetableId(value)
        )
    override val localGatewayRouteTableArn: Optional[ResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localGatewayRouteTableArn())
        .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val subnetId: Optional[SubnetId] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => zio.aws.ec2.model.primitives.SubnetId(value))
    override val coipPoolId: Optional[CoipPoolId] = zio.aws.core.internal
      .optionalFromNullable(impl.coipPoolId())
      .map(value => zio.aws.ec2.model.primitives.CoipPoolId(value))
    override val networkInterfaceId: Optional[NetworkInterfaceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaceId())
        .map(value => zio.aws.ec2.model.primitives.NetworkInterfaceId(value))
    override val destinationPrefixListId: Optional[PrefixListResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationPrefixListId())
        .map(value => zio.aws.ec2.model.primitives.PrefixListResourceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LocalGatewayRoute
  ): zio.aws.ec2.model.LocalGatewayRoute.ReadOnly = new Wrapper(impl)
}
