package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait IpamPoolCidrState {
  def unwrap: software.amazon.awssdk.services.ec2.model.IpamPoolCidrState
}
object IpamPoolCidrState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.IpamPoolCidrState
  ): zio.aws.ec2.model.IpamPoolCidrState = value match {
    case software.amazon.awssdk.services.ec2.model.IpamPoolCidrState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.IpamPoolCidrState.PENDING_PROVISION =>
      val r = `pending-provision`
      r
    case software.amazon.awssdk.services.ec2.model.IpamPoolCidrState.PROVISIONED =>
      val r = provisioned
      r
    case software.amazon.awssdk.services.ec2.model.IpamPoolCidrState.FAILED_PROVISION =>
      val r = `failed-provision`
      r
    case software.amazon.awssdk.services.ec2.model.IpamPoolCidrState.PENDING_DEPROVISION =>
      val r = `pending-deprovision`
      r
    case software.amazon.awssdk.services.ec2.model.IpamPoolCidrState.DEPROVISIONED =>
      val r = deprovisioned
      r
    case software.amazon.awssdk.services.ec2.model.IpamPoolCidrState.FAILED_DEPROVISION =>
      val r = `failed-deprovision`
      r
    case software.amazon.awssdk.services.ec2.model.IpamPoolCidrState.PENDING_IMPORT =>
      val r = `pending-import`
      r
    case software.amazon.awssdk.services.ec2.model.IpamPoolCidrState.FAILED_IMPORT =>
      val r = `failed-import`
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.IpamPoolCidrState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamPoolCidrState =
      software.amazon.awssdk.services.ec2.model.IpamPoolCidrState.UNKNOWN_TO_SDK_VERSION
  }
  case object `pending-provision` extends zio.aws.ec2.model.IpamPoolCidrState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamPoolCidrState =
      software.amazon.awssdk.services.ec2.model.IpamPoolCidrState.PENDING_PROVISION
  }
  case object provisioned extends zio.aws.ec2.model.IpamPoolCidrState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamPoolCidrState =
      software.amazon.awssdk.services.ec2.model.IpamPoolCidrState.PROVISIONED
  }
  case object `failed-provision` extends zio.aws.ec2.model.IpamPoolCidrState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamPoolCidrState =
      software.amazon.awssdk.services.ec2.model.IpamPoolCidrState.FAILED_PROVISION
  }
  case object `pending-deprovision`
      extends zio.aws.ec2.model.IpamPoolCidrState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamPoolCidrState =
      software.amazon.awssdk.services.ec2.model.IpamPoolCidrState.PENDING_DEPROVISION
  }
  case object deprovisioned extends zio.aws.ec2.model.IpamPoolCidrState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamPoolCidrState =
      software.amazon.awssdk.services.ec2.model.IpamPoolCidrState.DEPROVISIONED
  }
  case object `failed-deprovision` extends zio.aws.ec2.model.IpamPoolCidrState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamPoolCidrState =
      software.amazon.awssdk.services.ec2.model.IpamPoolCidrState.FAILED_DEPROVISION
  }
  case object `pending-import` extends zio.aws.ec2.model.IpamPoolCidrState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamPoolCidrState =
      software.amazon.awssdk.services.ec2.model.IpamPoolCidrState.PENDING_IMPORT
  }
  case object `failed-import` extends zio.aws.ec2.model.IpamPoolCidrState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamPoolCidrState =
      software.amazon.awssdk.services.ec2.model.IpamPoolCidrState.FAILED_IMPORT
  }
}
