package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait IpamDiscoveryFailureCode {
  def unwrap: software.amazon.awssdk.services.ec2.model.IpamDiscoveryFailureCode
}
object IpamDiscoveryFailureCode {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.IpamDiscoveryFailureCode
  ): zio.aws.ec2.model.IpamDiscoveryFailureCode = value match {
    case software.amazon.awssdk.services.ec2.model.IpamDiscoveryFailureCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.IpamDiscoveryFailureCode.ASSUME_ROLE_FAILURE =>
      val r = `assume-role-failure`
      r
    case software.amazon.awssdk.services.ec2.model.IpamDiscoveryFailureCode.THROTTLING_FAILURE =>
      val r = `throttling-failure`
      r
    case software.amazon.awssdk.services.ec2.model.IpamDiscoveryFailureCode.UNAUTHORIZED_FAILURE =>
      val r = `unauthorized-failure`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.IpamDiscoveryFailureCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamDiscoveryFailureCode =
      software.amazon.awssdk.services.ec2.model.IpamDiscoveryFailureCode.UNKNOWN_TO_SDK_VERSION
  }
  case object `assume-role-failure`
      extends zio.aws.ec2.model.IpamDiscoveryFailureCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamDiscoveryFailureCode =
      software.amazon.awssdk.services.ec2.model.IpamDiscoveryFailureCode.ASSUME_ROLE_FAILURE
  }
  case object `throttling-failure`
      extends zio.aws.ec2.model.IpamDiscoveryFailureCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamDiscoveryFailureCode =
      software.amazon.awssdk.services.ec2.model.IpamDiscoveryFailureCode.THROTTLING_FAILURE
  }
  case object `unauthorized-failure`
      extends zio.aws.ec2.model.IpamDiscoveryFailureCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamDiscoveryFailureCode =
      software.amazon.awssdk.services.ec2.model.IpamDiscoveryFailureCode.UNAUTHORIZED_FAILURE
  }
}
