package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  MillisecondDateTime,
  BoxedDouble,
  IpamResourceDiscoveryId
}
import scala.jdk.CollectionConverters._
final case class IpamDiscoveredResourceCidr(
    ipamResourceDiscoveryId: Optional[IpamResourceDiscoveryId] =
      Optional.Absent,
    resourceRegion: Optional[String] = Optional.Absent,
    resourceId: Optional[String] = Optional.Absent,
    resourceOwnerId: Optional[String] = Optional.Absent,
    resourceCidr: Optional[String] = Optional.Absent,
    resourceType: Optional[zio.aws.ec2.model.IpamResourceType] =
      Optional.Absent,
    resourceTags: Optional[Iterable[zio.aws.ec2.model.IpamResourceTag]] =
      Optional.Absent,
    ipUsage: Optional[BoxedDouble] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    sampleTime: Optional[MillisecondDateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.IpamDiscoveredResourceCidr = {
    import IpamDiscoveredResourceCidr.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.IpamDiscoveredResourceCidr
      .builder()
      .optionallyWith(
        ipamResourceDiscoveryId.map(value =>
          IpamResourceDiscoveryId.unwrap(value): java.lang.String
        )
      )(_.ipamResourceDiscoveryId)
      .optionallyWith(resourceRegion.map(value => value: java.lang.String))(
        _.resourceRegion
      )
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .optionallyWith(resourceOwnerId.map(value => value: java.lang.String))(
        _.resourceOwnerId
      )
      .optionallyWith(resourceCidr.map(value => value: java.lang.String))(
        _.resourceCidr
      )
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        resourceTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceTags)
      .optionallyWith(ipUsage.map(value => value: java.lang.Double))(_.ipUsage)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        sampleTime.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.sampleTime)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.IpamDiscoveredResourceCidr.ReadOnly =
    zio.aws.ec2.model.IpamDiscoveredResourceCidr.wrap(buildAwsValue())
}
object IpamDiscoveredResourceCidr {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.IpamDiscoveredResourceCidr
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.IpamDiscoveredResourceCidr =
      zio.aws.ec2.model.IpamDiscoveredResourceCidr(
        ipamResourceDiscoveryId.map(value => value),
        resourceRegion.map(value => value),
        resourceId.map(value => value),
        resourceOwnerId.map(value => value),
        resourceCidr.map(value => value),
        resourceType.map(value => value),
        resourceTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipUsage.map(value => value),
        vpcId.map(value => value),
        sampleTime.map(value => value)
      )
    def ipamResourceDiscoveryId: Optional[IpamResourceDiscoveryId]
    def resourceRegion: Optional[String]
    def resourceId: Optional[String]
    def resourceOwnerId: Optional[String]
    def resourceCidr: Optional[String]
    def resourceType: Optional[zio.aws.ec2.model.IpamResourceType]
    def resourceTags: Optional[List[zio.aws.ec2.model.IpamResourceTag.ReadOnly]]
    def ipUsage: Optional[BoxedDouble]
    def vpcId: Optional[String]
    def sampleTime: Optional[MillisecondDateTime]
    def getIpamResourceDiscoveryId
        : ZIO[Any, AwsError, IpamResourceDiscoveryId] = AwsError
      .unwrapOptionField("ipamResourceDiscoveryId", ipamResourceDiscoveryId)
    def getResourceRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceRegion", resourceRegion)
    def getResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceOwnerId", resourceOwnerId)
    def getResourceCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceCidr", resourceCidr)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.ec2.model.IpamResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceTags
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.IpamResourceTag.ReadOnly]] =
      AwsError.unwrapOptionField("resourceTags", resourceTags)
    def getIpUsage: ZIO[Any, AwsError, BoxedDouble] =
      AwsError.unwrapOptionField("ipUsage", ipUsage)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSampleTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("sampleTime", sampleTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.IpamDiscoveredResourceCidr
  ) extends zio.aws.ec2.model.IpamDiscoveredResourceCidr.ReadOnly {
    override val ipamResourceDiscoveryId: Optional[IpamResourceDiscoveryId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipamResourceDiscoveryId())
        .map(value =>
          zio.aws.ec2.model.primitives.IpamResourceDiscoveryId(value)
        )
    override val resourceRegion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceRegion())
      .map(value => value: String)
    override val resourceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => value: String)
    override val resourceOwnerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceOwnerId())
      .map(value => value: String)
    override val resourceCidr: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceCidr())
      .map(value => value: String)
    override val resourceType: Optional[zio.aws.ec2.model.IpamResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.ec2.model.IpamResourceType.wrap(value))
    override val resourceTags
        : Optional[List[zio.aws.ec2.model.IpamResourceTag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.IpamResourceTag.wrap(item)
          }.toList
        )
    override val ipUsage: Optional[BoxedDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.ipUsage())
      .map(value => value: BoxedDouble)
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val sampleTime: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sampleTime())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.IpamDiscoveredResourceCidr
  ): zio.aws.ec2.model.IpamDiscoveredResourceCidr.ReadOnly = new Wrapper(impl)
}
