package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait InstanceEventWindowState {
  def unwrap: software.amazon.awssdk.services.ec2.model.InstanceEventWindowState
}
object InstanceEventWindowState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.InstanceEventWindowState
  ): zio.aws.ec2.model.InstanceEventWindowState = value match {
    case software.amazon.awssdk.services.ec2.model.InstanceEventWindowState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.InstanceEventWindowState.CREATING =>
      val r = creating
      r
    case software.amazon.awssdk.services.ec2.model.InstanceEventWindowState.DELETING =>
      val r = deleting
      r
    case software.amazon.awssdk.services.ec2.model.InstanceEventWindowState.ACTIVE =>
      val r = active
      r
    case software.amazon.awssdk.services.ec2.model.InstanceEventWindowState.DELETED =>
      val r = deleted
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.InstanceEventWindowState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceEventWindowState =
      software.amazon.awssdk.services.ec2.model.InstanceEventWindowState.UNKNOWN_TO_SDK_VERSION
  }
  case object creating extends zio.aws.ec2.model.InstanceEventWindowState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceEventWindowState =
      software.amazon.awssdk.services.ec2.model.InstanceEventWindowState.CREATING
  }
  case object deleting extends zio.aws.ec2.model.InstanceEventWindowState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceEventWindowState =
      software.amazon.awssdk.services.ec2.model.InstanceEventWindowState.DELETING
  }
  case object active extends zio.aws.ec2.model.InstanceEventWindowState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceEventWindowState =
      software.amazon.awssdk.services.ec2.model.InstanceEventWindowState.ACTIVE
  }
  case object deleted extends zio.aws.ec2.model.InstanceEventWindowState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceEventWindowState =
      software.amazon.awssdk.services.ec2.model.InstanceEventWindowState.DELETED
  }
}
