package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  IpamMaxResults,
  NextToken,
  IpamResourceDiscoveryId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetIpamDiscoveredResourceCidrsRequest(
    ipamResourceDiscoveryId: IpamResourceDiscoveryId,
    resourceRegion: String,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[IpamMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetIpamDiscoveredResourceCidrsRequest = {
    import GetIpamDiscoveredResourceCidrsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetIpamDiscoveredResourceCidrsRequest
      .builder()
      .ipamResourceDiscoveryId(
        IpamResourceDiscoveryId.unwrap(
          ipamResourceDiscoveryId
        ): java.lang.String
      )
      .resourceRegion(resourceRegion: java.lang.String)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => IpamMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetIpamDiscoveredResourceCidrsRequest.ReadOnly =
    zio.aws.ec2.model.GetIpamDiscoveredResourceCidrsRequest
      .wrap(buildAwsValue())
}
object GetIpamDiscoveredResourceCidrsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetIpamDiscoveredResourceCidrsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetIpamDiscoveredResourceCidrsRequest =
      zio.aws.ec2.model.GetIpamDiscoveredResourceCidrsRequest(
        ipamResourceDiscoveryId,
        resourceRegion,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def ipamResourceDiscoveryId: IpamResourceDiscoveryId
    def resourceRegion: String
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[IpamMaxResults]
    def getIpamResourceDiscoveryId: ZIO[Any, Nothing, IpamResourceDiscoveryId] =
      ZIO.succeed(ipamResourceDiscoveryId)
    def getResourceRegion: ZIO[Any, Nothing, String] =
      ZIO.succeed(resourceRegion)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, IpamMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetIpamDiscoveredResourceCidrsRequest
  ) extends zio.aws.ec2.model.GetIpamDiscoveredResourceCidrsRequest.ReadOnly {
    override val ipamResourceDiscoveryId: IpamResourceDiscoveryId =
      zio.aws.ec2.model.primitives
        .IpamResourceDiscoveryId(impl.ipamResourceDiscoveryId())
    override val resourceRegion: String = impl.resourceRegion(): String
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val maxResults: Optional[IpamMaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.IpamMaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetIpamDiscoveredResourceCidrsRequest
  ): zio.aws.ec2.model.GetIpamDiscoveredResourceCidrsRequest.ReadOnly =
    new Wrapper(impl)
}
