package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetFlowLogsIntegrationTemplateResponse(
    result: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetFlowLogsIntegrationTemplateResponse = {
    import GetFlowLogsIntegrationTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetFlowLogsIntegrationTemplateResponse
      .builder()
      .optionallyWith(result.map(value => value: java.lang.String))(_.result)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetFlowLogsIntegrationTemplateResponse.ReadOnly =
    zio.aws.ec2.model.GetFlowLogsIntegrationTemplateResponse
      .wrap(buildAwsValue())
}
object GetFlowLogsIntegrationTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetFlowLogsIntegrationTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetFlowLogsIntegrationTemplateResponse =
      zio.aws.ec2.model
        .GetFlowLogsIntegrationTemplateResponse(result.map(value => value))
    def result: Optional[String]
    def getResult: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("result", result)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetFlowLogsIntegrationTemplateResponse
  ) extends zio.aws.ec2.model.GetFlowLogsIntegrationTemplateResponse.ReadOnly {
    override val result: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.result())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetFlowLogsIntegrationTemplateResponse
  ): zio.aws.ec2.model.GetFlowLogsIntegrationTemplateResponse.ReadOnly =
    new Wrapper(impl)
}
