package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FederatedAuthenticationRequest(
    samlProviderArn: Optional[String] = Optional.Absent,
    selfServiceSAMLProviderArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.FederatedAuthenticationRequest = {
    import FederatedAuthenticationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.FederatedAuthenticationRequest
      .builder()
      .optionallyWith(samlProviderArn.map(value => value: java.lang.String))(
        _.samlProviderArn
      )
      .optionallyWith(
        selfServiceSAMLProviderArn.map(value => value: java.lang.String)
      )(_.selfServiceSAMLProviderArn)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.FederatedAuthenticationRequest.ReadOnly =
    zio.aws.ec2.model.FederatedAuthenticationRequest.wrap(buildAwsValue())
}
object FederatedAuthenticationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.FederatedAuthenticationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.FederatedAuthenticationRequest =
      zio.aws.ec2.model.FederatedAuthenticationRequest(
        samlProviderArn.map(value => value),
        selfServiceSAMLProviderArn.map(value => value)
      )
    def samlProviderArn: Optional[String]
    def selfServiceSAMLProviderArn: Optional[String]
    def getSamlProviderArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("samlProviderArn", samlProviderArn)
    def getSelfServiceSAMLProviderArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "selfServiceSAMLProviderArn",
        selfServiceSAMLProviderArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.FederatedAuthenticationRequest
  ) extends zio.aws.ec2.model.FederatedAuthenticationRequest.ReadOnly {
    override val samlProviderArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.samlProviderArn())
      .map(value => value: String)
    override val selfServiceSAMLProviderArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.selfServiceSAMLProviderArn())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.FederatedAuthenticationRequest
  ): zio.aws.ec2.model.FederatedAuthenticationRequest.ReadOnly = new Wrapper(
    impl
  )
}
