package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DnsOptionsSpecification(
    dnsRecordIpType: Optional[zio.aws.ec2.model.DnsRecordIpType] =
      Optional.Absent,
    privateDnsOnlyForInboundResolverEndpoint: Optional[Boolean] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DnsOptionsSpecification = {
    import DnsOptionsSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DnsOptionsSpecification
      .builder()
      .optionallyWith(dnsRecordIpType.map(value => value.unwrap))(
        _.dnsRecordIpType
      )
      .optionallyWith(
        privateDnsOnlyForInboundResolverEndpoint.map(value =>
          value: java.lang.Boolean
        )
      )(_.privateDnsOnlyForInboundResolverEndpoint)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DnsOptionsSpecification.ReadOnly =
    zio.aws.ec2.model.DnsOptionsSpecification.wrap(buildAwsValue())
}
object DnsOptionsSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DnsOptionsSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DnsOptionsSpecification =
      zio.aws.ec2.model.DnsOptionsSpecification(
        dnsRecordIpType.map(value => value),
        privateDnsOnlyForInboundResolverEndpoint.map(value => value)
      )
    def dnsRecordIpType: Optional[zio.aws.ec2.model.DnsRecordIpType]
    def privateDnsOnlyForInboundResolverEndpoint: Optional[Boolean]
    def getDnsRecordIpType
        : ZIO[Any, AwsError, zio.aws.ec2.model.DnsRecordIpType] =
      AwsError.unwrapOptionField("dnsRecordIpType", dnsRecordIpType)
    def getPrivateDnsOnlyForInboundResolverEndpoint
        : ZIO[Any, AwsError, Boolean] = AwsError.unwrapOptionField(
      "privateDnsOnlyForInboundResolverEndpoint",
      privateDnsOnlyForInboundResolverEndpoint
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DnsOptionsSpecification
  ) extends zio.aws.ec2.model.DnsOptionsSpecification.ReadOnly {
    override val dnsRecordIpType: Optional[zio.aws.ec2.model.DnsRecordIpType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dnsRecordIpType())
        .map(value => zio.aws.ec2.model.DnsRecordIpType.wrap(value))
    override val privateDnsOnlyForInboundResolverEndpoint: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.privateDnsOnlyForInboundResolverEndpoint())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DnsOptionsSpecification
  ): zio.aws.ec2.model.DnsOptionsSpecification.ReadOnly = new Wrapper(impl)
}
