package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  DrainSeconds,
  ElasticIpAssociationId,
  NatGatewayId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DisassociateNatGatewayAddressRequest(
    natGatewayId: NatGatewayId,
    associationIds: Iterable[ElasticIpAssociationId],
    maxDrainDurationSeconds: Optional[DrainSeconds] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisassociateNatGatewayAddressRequest = {
    import DisassociateNatGatewayAddressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisassociateNatGatewayAddressRequest
      .builder()
      .natGatewayId(NatGatewayId.unwrap(natGatewayId): java.lang.String)
      .associationIds(associationIds.map { item =>
        ElasticIpAssociationId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        maxDrainDurationSeconds.map(value =>
          DrainSeconds.unwrap(value): Integer
        )
      )(_.maxDrainDurationSeconds)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisassociateNatGatewayAddressRequest.ReadOnly =
    zio.aws.ec2.model.DisassociateNatGatewayAddressRequest.wrap(buildAwsValue())
}
object DisassociateNatGatewayAddressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisassociateNatGatewayAddressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DisassociateNatGatewayAddressRequest =
      zio.aws.ec2.model.DisassociateNatGatewayAddressRequest(
        natGatewayId,
        associationIds,
        maxDrainDurationSeconds.map(value => value)
      )
    def natGatewayId: NatGatewayId
    def associationIds: List[ElasticIpAssociationId]
    def maxDrainDurationSeconds: Optional[DrainSeconds]
    def getNatGatewayId: ZIO[Any, Nothing, NatGatewayId] =
      ZIO.succeed(natGatewayId)
    def getAssociationIds: ZIO[Any, Nothing, List[ElasticIpAssociationId]] =
      ZIO.succeed(associationIds)
    def getMaxDrainDurationSeconds: ZIO[Any, AwsError, DrainSeconds] = AwsError
      .unwrapOptionField("maxDrainDurationSeconds", maxDrainDurationSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateNatGatewayAddressRequest
  ) extends zio.aws.ec2.model.DisassociateNatGatewayAddressRequest.ReadOnly {
    override val natGatewayId: NatGatewayId =
      zio.aws.ec2.model.primitives.NatGatewayId(impl.natGatewayId())
    override val associationIds: List[ElasticIpAssociationId] = impl
      .associationIds()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.ElasticIpAssociationId(item)
      }
      .toList
    override val maxDrainDurationSeconds: Optional[DrainSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxDrainDurationSeconds())
        .map(value => zio.aws.ec2.model.primitives.DrainSeconds(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateNatGatewayAddressRequest
  ): zio.aws.ec2.model.DisassociateNatGatewayAddressRequest.ReadOnly =
    new Wrapper(impl)
}
