package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{RouteTableId, VpnGatewayId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisableVgwRoutePropagationRequest(
    gatewayId: VpnGatewayId,
    routeTableId: RouteTableId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisableVgwRoutePropagationRequest = {
    import DisableVgwRoutePropagationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisableVgwRoutePropagationRequest
      .builder()
      .gatewayId(VpnGatewayId.unwrap(gatewayId): java.lang.String)
      .routeTableId(RouteTableId.unwrap(routeTableId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DisableVgwRoutePropagationRequest.ReadOnly =
    zio.aws.ec2.model.DisableVgwRoutePropagationRequest.wrap(buildAwsValue())
}
object DisableVgwRoutePropagationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisableVgwRoutePropagationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DisableVgwRoutePropagationRequest =
      zio.aws.ec2.model
        .DisableVgwRoutePropagationRequest(gatewayId, routeTableId)
    def gatewayId: VpnGatewayId
    def routeTableId: RouteTableId
    def getGatewayId: ZIO[Any, Nothing, VpnGatewayId] = ZIO.succeed(gatewayId)
    def getRouteTableId: ZIO[Any, Nothing, RouteTableId] =
      ZIO.succeed(routeTableId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisableVgwRoutePropagationRequest
  ) extends zio.aws.ec2.model.DisableVgwRoutePropagationRequest.ReadOnly {
    override val gatewayId: VpnGatewayId =
      zio.aws.ec2.model.primitives.VpnGatewayId(impl.gatewayId())
    override val routeTableId: RouteTableId =
      zio.aws.ec2.model.primitives.RouteTableId(impl.routeTableId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisableVgwRoutePropagationRequest
  ): zio.aws.ec2.model.DisableVgwRoutePropagationRequest.ReadOnly = new Wrapper(
    impl
  )
}
