package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{VpnGatewayId, VpcId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DetachVpnGatewayRequest(
    vpcId: VpcId,
    vpnGatewayId: VpnGatewayId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DetachVpnGatewayRequest = {
    import DetachVpnGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DetachVpnGatewayRequest
      .builder()
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .vpnGatewayId(VpnGatewayId.unwrap(vpnGatewayId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DetachVpnGatewayRequest.ReadOnly =
    zio.aws.ec2.model.DetachVpnGatewayRequest.wrap(buildAwsValue())
}
object DetachVpnGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DetachVpnGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DetachVpnGatewayRequest =
      zio.aws.ec2.model.DetachVpnGatewayRequest(vpcId, vpnGatewayId)
    def vpcId: VpcId
    def vpnGatewayId: VpnGatewayId
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
    def getVpnGatewayId: ZIO[Any, Nothing, VpnGatewayId] =
      ZIO.succeed(vpnGatewayId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DetachVpnGatewayRequest
  ) extends zio.aws.ec2.model.DetachVpnGatewayRequest.ReadOnly {
    override val vpcId: VpcId = zio.aws.ec2.model.primitives.VpcId(impl.vpcId())
    override val vpnGatewayId: VpnGatewayId =
      zio.aws.ec2.model.primitives.VpnGatewayId(impl.vpnGatewayId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DetachVpnGatewayRequest
  ): zio.aws.ec2.model.DetachVpnGatewayRequest.ReadOnly = new Wrapper(impl)
}
