package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, ConnectionNotificationId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeVpcEndpointConnectionNotificationsRequest(
    connectionNotificationId: Optional[ConnectionNotificationId] =
      Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest = {
    import DescribeVpcEndpointConnectionNotificationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest
      .builder()
      .optionallyWith(
        connectionNotificationId.map(value =>
          ConnectionNotificationId.unwrap(value): java.lang.String
        )
      )(_.connectionNotificationId)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest
      .wrap(buildAwsValue())
}
object DescribeVpcEndpointConnectionNotificationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest =
      zio.aws.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest(
        connectionNotificationId.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def connectionNotificationId: Optional[ConnectionNotificationId]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Optional[Integer]
    def nextToken: Optional[String]
    def getConnectionNotificationId
        : ZIO[Any, AwsError, ConnectionNotificationId] = AwsError
      .unwrapOptionField("connectionNotificationId", connectionNotificationId)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest
  ) extends zio.aws.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest.ReadOnly {
    override val connectionNotificationId: Optional[ConnectionNotificationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionNotificationId())
        .map(value =>
          zio.aws.ec2.model.primitives.ConnectionNotificationId(value)
        )
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest
  ): zio.aws.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest.ReadOnly =
    new Wrapper(impl)
}
