package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeTransitGatewaysResponse(
    transitGateways: Optional[Iterable[zio.aws.ec2.model.TransitGateway]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeTransitGatewaysResponse = {
    import DescribeTransitGatewaysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeTransitGatewaysResponse
      .builder()
      .optionallyWith(
        transitGateways.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.transitGateways)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeTransitGatewaysResponse.ReadOnly =
    zio.aws.ec2.model.DescribeTransitGatewaysResponse.wrap(buildAwsValue())
}
object DescribeTransitGatewaysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeTransitGatewaysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeTransitGatewaysResponse =
      zio.aws.ec2.model.DescribeTransitGatewaysResponse(
        transitGateways.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def transitGateways
        : Optional[List[zio.aws.ec2.model.TransitGateway.ReadOnly]]
    def nextToken: Optional[String]
    def getTransitGateways
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.TransitGateway.ReadOnly]] =
      AwsError.unwrapOptionField("transitGateways", transitGateways)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTransitGatewaysResponse
  ) extends zio.aws.ec2.model.DescribeTransitGatewaysResponse.ReadOnly {
    override val transitGateways
        : Optional[List[zio.aws.ec2.model.TransitGateway.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGateways())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TransitGateway.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTransitGatewaysResponse
  ): zio.aws.ec2.model.DescribeTransitGatewaysResponse.ReadOnly = new Wrapper(
    impl
  )
}
