package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeReservedInstancesOfferingsResponse(
    reservedInstancesOfferings: Optional[
      Iterable[zio.aws.ec2.model.ReservedInstancesOffering]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsResponse = {
    import DescribeReservedInstancesOfferingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsResponse
      .builder()
      .optionallyWith(
        reservedInstancesOfferings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reservedInstancesOfferings)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeReservedInstancesOfferingsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeReservedInstancesOfferingsResponse
      .wrap(buildAwsValue())
}
object DescribeReservedInstancesOfferingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeReservedInstancesOfferingsResponse =
      zio.aws.ec2.model.DescribeReservedInstancesOfferingsResponse(
        reservedInstancesOfferings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def reservedInstancesOfferings
        : Optional[List[zio.aws.ec2.model.ReservedInstancesOffering.ReadOnly]]
    def nextToken: Optional[String]
    def getReservedInstancesOfferings: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ReservedInstancesOffering.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "reservedInstancesOfferings",
      reservedInstancesOfferings
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsResponse
  ) extends zio.aws.ec2.model.DescribeReservedInstancesOfferingsResponse.ReadOnly {
    override val reservedInstancesOfferings
        : Optional[List[zio.aws.ec2.model.ReservedInstancesOffering.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedInstancesOfferings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ReservedInstancesOffering.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsResponse
  ): zio.aws.ec2.model.DescribeReservedInstancesOfferingsResponse.ReadOnly =
    new Wrapper(impl)
}
