package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  DescribeNetworkInterfacePermissionsMaxResults,
  NetworkInterfacePermissionId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeNetworkInterfacePermissionsRequest(
    networkInterfacePermissionIds: Optional[
      Iterable[NetworkInterfacePermissionId]
    ] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[DescribeNetworkInterfacePermissionsMaxResults] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacePermissionsRequest = {
    import DescribeNetworkInterfacePermissionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacePermissionsRequest
      .builder()
      .optionallyWith(
        networkInterfacePermissionIds.map(value =>
          value.map { item =>
            NetworkInterfacePermissionId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.networkInterfacePermissionIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value =>
          DescribeNetworkInterfacePermissionsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeNetworkInterfacePermissionsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeNetworkInterfacePermissionsRequest
      .wrap(buildAwsValue())
}
object DescribeNetworkInterfacePermissionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacePermissionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeNetworkInterfacePermissionsRequest =
      zio.aws.ec2.model.DescribeNetworkInterfacePermissionsRequest(
        networkInterfacePermissionIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def networkInterfacePermissionIds
        : Optional[List[NetworkInterfacePermissionId]]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def nextToken: Optional[String]
    def maxResults: Optional[DescribeNetworkInterfacePermissionsMaxResults]
    def getNetworkInterfacePermissionIds
        : ZIO[Any, AwsError, List[NetworkInterfacePermissionId]] =
      AwsError.unwrapOptionField(
        "networkInterfacePermissionIds",
        networkInterfacePermissionIds
      )
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, DescribeNetworkInterfacePermissionsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacePermissionsRequest
  ) extends zio.aws.ec2.model.DescribeNetworkInterfacePermissionsRequest.ReadOnly {
    override val networkInterfacePermissionIds
        : Optional[List[NetworkInterfacePermissionId]] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInterfacePermissionIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.NetworkInterfacePermissionId(item)
        }.toList
      )
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults
        : Optional[DescribeNetworkInterfacePermissionsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives
            .DescribeNetworkInterfacePermissionsMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacePermissionsRequest
  ): zio.aws.ec2.model.DescribeNetworkInterfacePermissionsRequest.ReadOnly =
    new Wrapper(impl)
}
