package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  NextToken,
  InstanceConnectEndpointMaxResults
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeInstanceConnectEndpointsRequest(
    maxResults: Optional[InstanceConnectEndpointMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    instanceConnectEndpointIds: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeInstanceConnectEndpointsRequest = {
    import DescribeInstanceConnectEndpointsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeInstanceConnectEndpointsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          InstanceConnectEndpointMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        instanceConnectEndpointIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.instanceConnectEndpointIds)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeInstanceConnectEndpointsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeInstanceConnectEndpointsRequest
      .wrap(buildAwsValue())
}
object DescribeInstanceConnectEndpointsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeInstanceConnectEndpointsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeInstanceConnectEndpointsRequest =
      zio.aws.ec2.model.DescribeInstanceConnectEndpointsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instanceConnectEndpointIds.map(value => value)
      )
    def maxResults: Optional[InstanceConnectEndpointMaxResults]
    def nextToken: Optional[NextToken]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def instanceConnectEndpointIds: Optional[List[String]]
    def getMaxResults: ZIO[Any, AwsError, InstanceConnectEndpointMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getInstanceConnectEndpointIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "instanceConnectEndpointIds",
        instanceConnectEndpointIds
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceConnectEndpointsRequest
  ) extends zio.aws.ec2.model.DescribeInstanceConnectEndpointsRequest.ReadOnly {
    override val maxResults: Optional[InstanceConnectEndpointMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives.InstanceConnectEndpointMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val instanceConnectEndpointIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceConnectEndpointIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceConnectEndpointsRequest
  ): zio.aws.ec2.model.DescribeInstanceConnectEndpointsRequest.ReadOnly =
    new Wrapper(impl)
}
