package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TransitGatewayAttachmentId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateTransitGatewayConnectRequest(
    transportTransitGatewayAttachmentId: TransitGatewayAttachmentId,
    options: zio.aws.ec2.model.CreateTransitGatewayConnectRequestOptions,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateTransitGatewayConnectRequest = {
    import CreateTransitGatewayConnectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateTransitGatewayConnectRequest
      .builder()
      .transportTransitGatewayAttachmentId(
        TransitGatewayAttachmentId.unwrap(
          transportTransitGatewayAttachmentId
        ): java.lang.String
      )
      .options(options.buildAwsValue())
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateTransitGatewayConnectRequest.ReadOnly =
    zio.aws.ec2.model.CreateTransitGatewayConnectRequest.wrap(buildAwsValue())
}
object CreateTransitGatewayConnectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateTransitGatewayConnectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateTransitGatewayConnectRequest =
      zio.aws.ec2.model.CreateTransitGatewayConnectRequest(
        transportTransitGatewayAttachmentId,
        options.asEditable,
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def transportTransitGatewayAttachmentId: TransitGatewayAttachmentId
    def options
        : zio.aws.ec2.model.CreateTransitGatewayConnectRequestOptions.ReadOnly
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getTransportTransitGatewayAttachmentId
        : ZIO[Any, Nothing, TransitGatewayAttachmentId] =
      ZIO.succeed(transportTransitGatewayAttachmentId)
    def getOptions: ZIO[
      Any,
      Nothing,
      zio.aws.ec2.model.CreateTransitGatewayConnectRequestOptions.ReadOnly
    ] = ZIO.succeed(options)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateTransitGatewayConnectRequest
  ) extends zio.aws.ec2.model.CreateTransitGatewayConnectRequest.ReadOnly {
    override val transportTransitGatewayAttachmentId
        : TransitGatewayAttachmentId = zio.aws.ec2.model.primitives
      .TransitGatewayAttachmentId(impl.transportTransitGatewayAttachmentId())
    override val options
        : zio.aws.ec2.model.CreateTransitGatewayConnectRequestOptions.ReadOnly =
      zio.aws.ec2.model.CreateTransitGatewayConnectRequestOptions
        .wrap(impl.options())
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateTransitGatewayConnectRequest
  ): zio.aws.ec2.model.CreateTransitGatewayConnectRequest.ReadOnly =
    new Wrapper(impl)
}
