package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreatePlacementGroupRequest(
    groupName: Optional[String] = Optional.Absent,
    strategy: Optional[zio.aws.ec2.model.PlacementStrategy] = Optional.Absent,
    partitionCount: Optional[Integer] = Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    spreadLevel: Optional[zio.aws.ec2.model.SpreadLevel] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreatePlacementGroupRequest = {
    import CreatePlacementGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreatePlacementGroupRequest
      .builder()
      .optionallyWith(groupName.map(value => value: java.lang.String))(
        _.groupName
      )
      .optionallyWith(strategy.map(value => value.unwrap))(_.strategy)
      .optionallyWith(partitionCount.map(value => value: java.lang.Integer))(
        _.partitionCount
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(spreadLevel.map(value => value.unwrap))(_.spreadLevel)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreatePlacementGroupRequest.ReadOnly =
    zio.aws.ec2.model.CreatePlacementGroupRequest.wrap(buildAwsValue())
}
object CreatePlacementGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreatePlacementGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreatePlacementGroupRequest =
      zio.aws.ec2.model.CreatePlacementGroupRequest(
        groupName.map(value => value),
        strategy.map(value => value),
        partitionCount.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        spreadLevel.map(value => value)
      )
    def groupName: Optional[String]
    def strategy: Optional[zio.aws.ec2.model.PlacementStrategy]
    def partitionCount: Optional[Integer]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def spreadLevel: Optional[zio.aws.ec2.model.SpreadLevel]
    def getGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getStrategy: ZIO[Any, AwsError, zio.aws.ec2.model.PlacementStrategy] =
      AwsError.unwrapOptionField("strategy", strategy)
    def getPartitionCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("partitionCount", partitionCount)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getSpreadLevel: ZIO[Any, AwsError, zio.aws.ec2.model.SpreadLevel] =
      AwsError.unwrapOptionField("spreadLevel", spreadLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreatePlacementGroupRequest
  ) extends zio.aws.ec2.model.CreatePlacementGroupRequest.ReadOnly {
    override val groupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => value: String)
    override val strategy: Optional[zio.aws.ec2.model.PlacementStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.strategy())
        .map(value => zio.aws.ec2.model.PlacementStrategy.wrap(value))
    override val partitionCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.partitionCount())
      .map(value => value: Integer)
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val spreadLevel: Optional[zio.aws.ec2.model.SpreadLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.spreadLevel())
        .map(value => zio.aws.ec2.model.SpreadLevel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreatePlacementGroupRequest
  ): zio.aws.ec2.model.CreatePlacementGroupRequest.ReadOnly = new Wrapper(impl)
}
