package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{SecurityGroupId, SubnetId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateInstanceConnectEndpointRequest(
    subnetId: SubnetId,
    securityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    preserveClientIp: Optional[Boolean] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateInstanceConnectEndpointRequest = {
    import CreateInstanceConnectEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateInstanceConnectEndpointRequest
      .builder()
      .subnetId(SubnetId.unwrap(subnetId): java.lang.String)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(preserveClientIp.map(value => value: java.lang.Boolean))(
        _.preserveClientIp
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateInstanceConnectEndpointRequest.ReadOnly =
    zio.aws.ec2.model.CreateInstanceConnectEndpointRequest.wrap(buildAwsValue())
}
object CreateInstanceConnectEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateInstanceConnectEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateInstanceConnectEndpointRequest =
      zio.aws.ec2.model.CreateInstanceConnectEndpointRequest(
        subnetId,
        securityGroupIds.map(value => value),
        preserveClientIp.map(value => value),
        clientToken.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def subnetId: SubnetId
    def securityGroupIds: Optional[List[SecurityGroupId]]
    def preserveClientIp: Optional[Boolean]
    def clientToken: Optional[String]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getSubnetId: ZIO[Any, Nothing, SubnetId] = ZIO.succeed(subnetId)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getPreserveClientIp: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("preserveClientIp", preserveClientIp)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateInstanceConnectEndpointRequest
  ) extends zio.aws.ec2.model.CreateInstanceConnectEndpointRequest.ReadOnly {
    override val subnetId: SubnetId =
      zio.aws.ec2.model.primitives.SubnetId(impl.subnetId())
    override val securityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val preserveClientIp: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.preserveClientIp())
      .map(value => value: Boolean)
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateInstanceConnectEndpointRequest
  ): zio.aws.ec2.model.CreateInstanceConnectEndpointRequest.ReadOnly =
    new Wrapper(impl)
}
