package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait CarrierGatewayState {
  def unwrap: software.amazon.awssdk.services.ec2.model.CarrierGatewayState
}
object CarrierGatewayState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.CarrierGatewayState
  ): zio.aws.ec2.model.CarrierGatewayState = value match {
    case software.amazon.awssdk.services.ec2.model.CarrierGatewayState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.CarrierGatewayState.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.ec2.model.CarrierGatewayState.AVAILABLE =>
      val r = available
      r
    case software.amazon.awssdk.services.ec2.model.CarrierGatewayState.DELETING =>
      val r = deleting
      r
    case software.amazon.awssdk.services.ec2.model.CarrierGatewayState.DELETED =>
      val r = deleted
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.CarrierGatewayState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CarrierGatewayState =
      software.amazon.awssdk.services.ec2.model.CarrierGatewayState.UNKNOWN_TO_SDK_VERSION
  }
  case object pending extends zio.aws.ec2.model.CarrierGatewayState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CarrierGatewayState =
      software.amazon.awssdk.services.ec2.model.CarrierGatewayState.PENDING
  }
  case object available extends zio.aws.ec2.model.CarrierGatewayState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CarrierGatewayState =
      software.amazon.awssdk.services.ec2.model.CarrierGatewayState.AVAILABLE
  }
  case object deleting extends zio.aws.ec2.model.CarrierGatewayState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CarrierGatewayState =
      software.amazon.awssdk.services.ec2.model.CarrierGatewayState.DELETING
  }
  case object deleted extends zio.aws.ec2.model.CarrierGatewayState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CarrierGatewayState =
      software.amazon.awssdk.services.ec2.model.CarrierGatewayState.DELETED
  }
}
