package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SpotFleetRequestId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CancelSpotFleetRequestsRequest(
    spotFleetRequestIds: Iterable[SpotFleetRequestId],
    terminateInstances: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsRequest = {
    import CancelSpotFleetRequestsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsRequest
      .builder()
      .spotFleetRequestIds(spotFleetRequestIds.map { item =>
        SpotFleetRequestId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .terminateInstances(terminateInstances: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CancelSpotFleetRequestsRequest.ReadOnly =
    zio.aws.ec2.model.CancelSpotFleetRequestsRequest.wrap(buildAwsValue())
}
object CancelSpotFleetRequestsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CancelSpotFleetRequestsRequest =
      zio.aws.ec2.model
        .CancelSpotFleetRequestsRequest(spotFleetRequestIds, terminateInstances)
    def spotFleetRequestIds: List[SpotFleetRequestId]
    def terminateInstances: Boolean
    def getSpotFleetRequestIds: ZIO[Any, Nothing, List[SpotFleetRequestId]] =
      ZIO.succeed(spotFleetRequestIds)
    def getTerminateInstances: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(terminateInstances)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsRequest
  ) extends zio.aws.ec2.model.CancelSpotFleetRequestsRequest.ReadOnly {
    override val spotFleetRequestIds: List[SpotFleetRequestId] = impl
      .spotFleetRequestIds()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.SpotFleetRequestId(item)
      }
      .toList
    override val terminateInstances: Boolean =
      impl.terminateInstances(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsRequest
  ): zio.aws.ec2.model.CancelSpotFleetRequestsRequest.ReadOnly = new Wrapper(
    impl
  )
}
