package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  CancelCapacityReservationFleetErrorMessage,
  CancelCapacityReservationFleetErrorCode
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CancelCapacityReservationFleetError(
    code: Optional[CancelCapacityReservationFleetErrorCode] = Optional.Absent,
    message: Optional[CancelCapacityReservationFleetErrorMessage] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CancelCapacityReservationFleetError = {
    import CancelCapacityReservationFleetError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CancelCapacityReservationFleetError
      .builder()
      .optionallyWith(
        code.map(value =>
          CancelCapacityReservationFleetErrorCode.unwrap(
            value
          ): java.lang.String
        )
      )(_.code)
      .optionallyWith(
        message.map(value =>
          CancelCapacityReservationFleetErrorMessage.unwrap(
            value
          ): java.lang.String
        )
      )(_.message)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CancelCapacityReservationFleetError.ReadOnly =
    zio.aws.ec2.model.CancelCapacityReservationFleetError.wrap(buildAwsValue())
}
object CancelCapacityReservationFleetError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CancelCapacityReservationFleetError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CancelCapacityReservationFleetError =
      zio.aws.ec2.model.CancelCapacityReservationFleetError(
        code.map(value => value),
        message.map(value => value)
      )
    def code: Optional[CancelCapacityReservationFleetErrorCode]
    def message: Optional[CancelCapacityReservationFleetErrorMessage]
    def getCode: ZIO[Any, AwsError, CancelCapacityReservationFleetErrorCode] =
      AwsError.unwrapOptionField("code", code)
    def getMessage
        : ZIO[Any, AwsError, CancelCapacityReservationFleetErrorMessage] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CancelCapacityReservationFleetError
  ) extends zio.aws.ec2.model.CancelCapacityReservationFleetError.ReadOnly {
    override val code: Optional[CancelCapacityReservationFleetErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.code())
        .map(value =>
          zio.aws.ec2.model.primitives
            .CancelCapacityReservationFleetErrorCode(value)
        )
    override val message: Optional[CancelCapacityReservationFleetErrorMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.message())
        .map(value =>
          zio.aws.ec2.model.primitives
            .CancelCapacityReservationFleetErrorMessage(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CancelCapacityReservationFleetError
  ): zio.aws.ec2.model.CancelCapacityReservationFleetError.ReadOnly =
    new Wrapper(impl)
}
