package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{RoleId, CertificateId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssociateEnclaveCertificateIamRoleRequest(
    certificateArn: CertificateId,
    roleArn: RoleId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssociateEnclaveCertificateIamRoleRequest = {
    import AssociateEnclaveCertificateIamRoleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssociateEnclaveCertificateIamRoleRequest
      .builder()
      .certificateArn(CertificateId.unwrap(certificateArn): java.lang.String)
      .roleArn(RoleId.unwrap(roleArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AssociateEnclaveCertificateIamRoleRequest.ReadOnly =
    zio.aws.ec2.model.AssociateEnclaveCertificateIamRoleRequest
      .wrap(buildAwsValue())
}
object AssociateEnclaveCertificateIamRoleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssociateEnclaveCertificateIamRoleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.AssociateEnclaveCertificateIamRoleRequest =
      zio.aws.ec2.model
        .AssociateEnclaveCertificateIamRoleRequest(certificateArn, roleArn)
    def certificateArn: CertificateId
    def roleArn: RoleId
    def getCertificateArn: ZIO[Any, Nothing, CertificateId] =
      ZIO.succeed(certificateArn)
    def getRoleArn: ZIO[Any, Nothing, RoleId] = ZIO.succeed(roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssociateEnclaveCertificateIamRoleRequest
  ) extends zio.aws.ec2.model.AssociateEnclaveCertificateIamRoleRequest.ReadOnly {
    override val certificateArn: CertificateId =
      zio.aws.ec2.model.primitives.CertificateId(impl.certificateArn())
    override val roleArn: RoleId =
      zio.aws.ec2.model.primitives.RoleId(impl.roleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssociateEnclaveCertificateIamRoleRequest
  ): zio.aws.ec2.model.AssociateEnclaveCertificateIamRoleRequest.ReadOnly =
    new Wrapper(impl)
}
