package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ArchitectureType {
  def unwrap: software.amazon.awssdk.services.ec2.model.ArchitectureType
}
object ArchitectureType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ArchitectureType
  ): zio.aws.ec2.model.ArchitectureType = value match {
    case software.amazon.awssdk.services.ec2.model.ArchitectureType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ArchitectureType.I386 =>
      val r = i386
      r
    case software.amazon.awssdk.services.ec2.model.ArchitectureType.X86_64 =>
      val r = x86_64
      r
    case software.amazon.awssdk.services.ec2.model.ArchitectureType.ARM64 =>
      val r = arm64
      r
    case software.amazon.awssdk.services.ec2.model.ArchitectureType.X86_64_MAC =>
      val r = x86_64_mac
      r
    case software.amazon.awssdk.services.ec2.model.ArchitectureType.ARM64_MAC =>
      val r = arm64_mac
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.ArchitectureType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ArchitectureType =
      software.amazon.awssdk.services.ec2.model.ArchitectureType.UNKNOWN_TO_SDK_VERSION
  }
  case object i386 extends zio.aws.ec2.model.ArchitectureType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ArchitectureType =
      software.amazon.awssdk.services.ec2.model.ArchitectureType.I386
  }
  case object x86_64 extends zio.aws.ec2.model.ArchitectureType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ArchitectureType =
      software.amazon.awssdk.services.ec2.model.ArchitectureType.X86_64
  }
  case object arm64 extends zio.aws.ec2.model.ArchitectureType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ArchitectureType =
      software.amazon.awssdk.services.ec2.model.ArchitectureType.ARM64
  }
  case object x86_64_mac extends zio.aws.ec2.model.ArchitectureType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ArchitectureType =
      software.amazon.awssdk.services.ec2.model.ArchitectureType.X86_64_MAC
  }
  case object arm64_mac extends zio.aws.ec2.model.ArchitectureType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ArchitectureType =
      software.amazon.awssdk.services.ec2.model.ArchitectureType.ARM64_MAC
  }
}
