package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{DrainSeconds, NatGatewayId}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UnassignPrivateNatGatewayAddressRequest(
    natGatewayId: NatGatewayId,
    privateIpAddresses: Iterable[String],
    maxDrainDurationSeconds: Optional[DrainSeconds] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.UnassignPrivateNatGatewayAddressRequest = {
    import UnassignPrivateNatGatewayAddressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.UnassignPrivateNatGatewayAddressRequest
      .builder()
      .natGatewayId(NatGatewayId.unwrap(natGatewayId): java.lang.String)
      .privateIpAddresses(privateIpAddresses.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        maxDrainDurationSeconds.map(value =>
          DrainSeconds.unwrap(value): Integer
        )
      )(_.maxDrainDurationSeconds)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.UnassignPrivateNatGatewayAddressRequest.ReadOnly =
    zio.aws.ec2.model.UnassignPrivateNatGatewayAddressRequest
      .wrap(buildAwsValue())
}
object UnassignPrivateNatGatewayAddressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.UnassignPrivateNatGatewayAddressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.UnassignPrivateNatGatewayAddressRequest =
      zio.aws.ec2.model.UnassignPrivateNatGatewayAddressRequest(
        natGatewayId,
        privateIpAddresses,
        maxDrainDurationSeconds.map(value => value)
      )
    def natGatewayId: NatGatewayId
    def privateIpAddresses: List[String]
    def maxDrainDurationSeconds: Optional[DrainSeconds]
    def getNatGatewayId: ZIO[Any, Nothing, NatGatewayId] =
      ZIO.succeed(natGatewayId)
    def getPrivateIpAddresses: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(privateIpAddresses)
    def getMaxDrainDurationSeconds: ZIO[Any, AwsError, DrainSeconds] = AwsError
      .unwrapOptionField("maxDrainDurationSeconds", maxDrainDurationSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.UnassignPrivateNatGatewayAddressRequest
  ) extends zio.aws.ec2.model.UnassignPrivateNatGatewayAddressRequest.ReadOnly {
    override val natGatewayId: NatGatewayId =
      zio.aws.ec2.model.primitives.NatGatewayId(impl.natGatewayId())
    override val privateIpAddresses: List[String] = impl
      .privateIpAddresses()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val maxDrainDurationSeconds: Optional[DrainSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxDrainDurationSeconds())
        .map(value => zio.aws.ec2.model.primitives.DrainSeconds(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.UnassignPrivateNatGatewayAddressRequest
  ): zio.aws.ec2.model.UnassignPrivateNatGatewayAddressRequest.ReadOnly =
    new Wrapper(impl)
}
