package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TransitGatewayConnectPeerConfiguration(
    transitGatewayAddress: Optional[String] = Optional.Absent,
    peerAddress: Optional[String] = Optional.Absent,
    insideCidrBlocks: Optional[Iterable[String]] = Optional.Absent,
    protocol: Optional[zio.aws.ec2.model.ProtocolValue] = Optional.Absent,
    bgpConfigurations: Optional[
      Iterable[zio.aws.ec2.model.TransitGatewayAttachmentBgpConfiguration]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeerConfiguration = {
    import TransitGatewayConnectPeerConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeerConfiguration
      .builder()
      .optionallyWith(
        transitGatewayAddress.map(value => value: java.lang.String)
      )(_.transitGatewayAddress)
      .optionallyWith(peerAddress.map(value => value: java.lang.String))(
        _.peerAddress
      )
      .optionallyWith(
        insideCidrBlocks.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.insideCidrBlocks)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(
        bgpConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.bgpConfigurations)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.TransitGatewayConnectPeerConfiguration.ReadOnly =
    zio.aws.ec2.model.TransitGatewayConnectPeerConfiguration
      .wrap(buildAwsValue())
}
object TransitGatewayConnectPeerConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeerConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayConnectPeerConfiguration =
      zio.aws.ec2.model.TransitGatewayConnectPeerConfiguration(
        transitGatewayAddress.map(value => value),
        peerAddress.map(value => value),
        insideCidrBlocks.map(value => value),
        protocol.map(value => value),
        bgpConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def transitGatewayAddress: Optional[String]
    def peerAddress: Optional[String]
    def insideCidrBlocks: Optional[List[String]]
    def protocol: Optional[zio.aws.ec2.model.ProtocolValue]
    def bgpConfigurations: Optional[
      List[zio.aws.ec2.model.TransitGatewayAttachmentBgpConfiguration.ReadOnly]
    ]
    def getTransitGatewayAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transitGatewayAddress", transitGatewayAddress)
    def getPeerAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("peerAddress", peerAddress)
    def getInsideCidrBlocks: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("insideCidrBlocks", insideCidrBlocks)
    def getProtocol: ZIO[Any, AwsError, zio.aws.ec2.model.ProtocolValue] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getBgpConfigurations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TransitGatewayAttachmentBgpConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("bgpConfigurations", bgpConfigurations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeerConfiguration
  ) extends zio.aws.ec2.model.TransitGatewayConnectPeerConfiguration.ReadOnly {
    override val transitGatewayAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayAddress())
      .map(value => value: String)
    override val peerAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.peerAddress())
      .map(value => value: String)
    override val insideCidrBlocks: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.insideCidrBlocks())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val protocol: Optional[zio.aws.ec2.model.ProtocolValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocol())
        .map(value => zio.aws.ec2.model.ProtocolValue.wrap(value))
    override val bgpConfigurations: Optional[
      List[zio.aws.ec2.model.TransitGatewayAttachmentBgpConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.bgpConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TransitGatewayAttachmentBgpConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeerConfiguration
  ): zio.aws.ec2.model.TransitGatewayConnectPeerConfiguration.ReadOnly =
    new Wrapper(impl)
}
