package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OidcOptions(
    issuer: Optional[String] = Optional.Absent,
    authorizationEndpoint: Optional[String] = Optional.Absent,
    tokenEndpoint: Optional[String] = Optional.Absent,
    userInfoEndpoint: Optional[String] = Optional.Absent,
    clientId: Optional[String] = Optional.Absent,
    clientSecret: Optional[String] = Optional.Absent,
    scope: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.OidcOptions = {
    import OidcOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.OidcOptions
      .builder()
      .optionallyWith(issuer.map(value => value: java.lang.String))(_.issuer)
      .optionallyWith(
        authorizationEndpoint.map(value => value: java.lang.String)
      )(_.authorizationEndpoint)
      .optionallyWith(tokenEndpoint.map(value => value: java.lang.String))(
        _.tokenEndpoint
      )
      .optionallyWith(userInfoEndpoint.map(value => value: java.lang.String))(
        _.userInfoEndpoint
      )
      .optionallyWith(clientId.map(value => value: java.lang.String))(
        _.clientId
      )
      .optionallyWith(clientSecret.map(value => value: java.lang.String))(
        _.clientSecret
      )
      .optionallyWith(scope.map(value => value: java.lang.String))(_.scope)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.OidcOptions.ReadOnly =
    zio.aws.ec2.model.OidcOptions.wrap(buildAwsValue())
}
object OidcOptions {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.OidcOptions] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.OidcOptions =
      zio.aws.ec2.model.OidcOptions(
        issuer.map(value => value),
        authorizationEndpoint.map(value => value),
        tokenEndpoint.map(value => value),
        userInfoEndpoint.map(value => value),
        clientId.map(value => value),
        clientSecret.map(value => value),
        scope.map(value => value)
      )
    def issuer: Optional[String]
    def authorizationEndpoint: Optional[String]
    def tokenEndpoint: Optional[String]
    def userInfoEndpoint: Optional[String]
    def clientId: Optional[String]
    def clientSecret: Optional[String]
    def scope: Optional[String]
    def getIssuer: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("issuer", issuer)
    def getAuthorizationEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("authorizationEndpoint", authorizationEndpoint)
    def getTokenEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tokenEndpoint", tokenEndpoint)
    def getUserInfoEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userInfoEndpoint", userInfoEndpoint)
    def getClientId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientId", clientId)
    def getClientSecret: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientSecret", clientSecret)
    def getScope: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("scope", scope)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.OidcOptions
  ) extends zio.aws.ec2.model.OidcOptions.ReadOnly {
    override val issuer: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.issuer())
      .map(value => value: String)
    override val authorizationEndpoint: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.authorizationEndpoint())
      .map(value => value: String)
    override val tokenEndpoint: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tokenEndpoint())
      .map(value => value: String)
    override val userInfoEndpoint: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.userInfoEndpoint())
      .map(value => value: String)
    override val clientId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientId())
      .map(value => value: String)
    override val clientSecret: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientSecret())
      .map(value => value: String)
    override val scope: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.scope())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.OidcOptions
  ): zio.aws.ec2.model.OidcOptions.ReadOnly = new Wrapper(impl)
}
