package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait NatGatewayAddressStatus {
  def unwrap: software.amazon.awssdk.services.ec2.model.NatGatewayAddressStatus
}
object NatGatewayAddressStatus {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.NatGatewayAddressStatus
  ): zio.aws.ec2.model.NatGatewayAddressStatus = value match {
    case software.amazon.awssdk.services.ec2.model.NatGatewayAddressStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.NatGatewayAddressStatus.ASSIGNING =>
      val r = assigning
      r
    case software.amazon.awssdk.services.ec2.model.NatGatewayAddressStatus.UNASSIGNING =>
      val r = unassigning
      r
    case software.amazon.awssdk.services.ec2.model.NatGatewayAddressStatus.ASSOCIATING =>
      val r = associating
      r
    case software.amazon.awssdk.services.ec2.model.NatGatewayAddressStatus.DISASSOCIATING =>
      val r = disassociating
      r
    case software.amazon.awssdk.services.ec2.model.NatGatewayAddressStatus.SUCCEEDED =>
      val r = succeeded
      r
    case software.amazon.awssdk.services.ec2.model.NatGatewayAddressStatus.FAILED =>
      val r = failed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.NatGatewayAddressStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NatGatewayAddressStatus =
      software.amazon.awssdk.services.ec2.model.NatGatewayAddressStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object assigning extends zio.aws.ec2.model.NatGatewayAddressStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NatGatewayAddressStatus =
      software.amazon.awssdk.services.ec2.model.NatGatewayAddressStatus.ASSIGNING
  }
  case object unassigning extends zio.aws.ec2.model.NatGatewayAddressStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NatGatewayAddressStatus =
      software.amazon.awssdk.services.ec2.model.NatGatewayAddressStatus.UNASSIGNING
  }
  case object associating extends zio.aws.ec2.model.NatGatewayAddressStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NatGatewayAddressStatus =
      software.amazon.awssdk.services.ec2.model.NatGatewayAddressStatus.ASSOCIATING
  }
  case object disassociating extends zio.aws.ec2.model.NatGatewayAddressStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NatGatewayAddressStatus =
      software.amazon.awssdk.services.ec2.model.NatGatewayAddressStatus.DISASSOCIATING
  }
  case object succeeded extends zio.aws.ec2.model.NatGatewayAddressStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NatGatewayAddressStatus =
      software.amazon.awssdk.services.ec2.model.NatGatewayAddressStatus.SUCCEEDED
  }
  case object failed extends zio.aws.ec2.model.NatGatewayAddressStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NatGatewayAddressStatus =
      software.amazon.awssdk.services.ec2.model.NatGatewayAddressStatus.FAILED
  }
}
