package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MovingAddressStatus(
    moveStatus: Optional[zio.aws.ec2.model.MoveStatus] = Optional.Absent,
    publicIp: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.MovingAddressStatus = {
    import MovingAddressStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.MovingAddressStatus
      .builder()
      .optionallyWith(moveStatus.map(value => value.unwrap))(_.moveStatus)
      .optionallyWith(publicIp.map(value => value: java.lang.String))(
        _.publicIp
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.MovingAddressStatus.ReadOnly =
    zio.aws.ec2.model.MovingAddressStatus.wrap(buildAwsValue())
}
object MovingAddressStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.MovingAddressStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.MovingAddressStatus =
      zio.aws.ec2.model.MovingAddressStatus(
        moveStatus.map(value => value),
        publicIp.map(value => value)
      )
    def moveStatus: Optional[zio.aws.ec2.model.MoveStatus]
    def publicIp: Optional[String]
    def getMoveStatus: ZIO[Any, AwsError, zio.aws.ec2.model.MoveStatus] =
      AwsError.unwrapOptionField("moveStatus", moveStatus)
    def getPublicIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("publicIp", publicIp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.MovingAddressStatus
  ) extends zio.aws.ec2.model.MovingAddressStatus.ReadOnly {
    override val moveStatus: Optional[zio.aws.ec2.model.MoveStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.moveStatus())
        .map(value => zio.aws.ec2.model.MoveStatus.wrap(value))
    override val publicIp: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.publicIp())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.MovingAddressStatus
  ): zio.aws.ec2.model.MovingAddressStatus.ReadOnly = new Wrapper(impl)
}
