package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyInstanceCreditSpecificationRequest(
    clientToken: Optional[String] = Optional.Absent,
    instanceCreditSpecifications: Iterable[
      zio.aws.ec2.model.InstanceCreditSpecificationRequest
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyInstanceCreditSpecificationRequest = {
    import ModifyInstanceCreditSpecificationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyInstanceCreditSpecificationRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .instanceCreditSpecifications(instanceCreditSpecifications.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyInstanceCreditSpecificationRequest.ReadOnly =
    zio.aws.ec2.model.ModifyInstanceCreditSpecificationRequest
      .wrap(buildAwsValue())
}
object ModifyInstanceCreditSpecificationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyInstanceCreditSpecificationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyInstanceCreditSpecificationRequest =
      zio.aws.ec2.model.ModifyInstanceCreditSpecificationRequest(
        clientToken.map(value => value),
        instanceCreditSpecifications.map { item =>
          item.asEditable
        }
      )
    def clientToken: Optional[String]
    def instanceCreditSpecifications
        : List[zio.aws.ec2.model.InstanceCreditSpecificationRequest.ReadOnly]
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getInstanceCreditSpecifications: ZIO[Any, Nothing, List[
      zio.aws.ec2.model.InstanceCreditSpecificationRequest.ReadOnly
    ]] = ZIO.succeed(instanceCreditSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyInstanceCreditSpecificationRequest
  ) extends zio.aws.ec2.model.ModifyInstanceCreditSpecificationRequest.ReadOnly {
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val instanceCreditSpecifications
        : List[zio.aws.ec2.model.InstanceCreditSpecificationRequest.ReadOnly] =
      impl
        .instanceCreditSpecifications()
        .asScala
        .map { item =>
          zio.aws.ec2.model.InstanceCreditSpecificationRequest.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyInstanceCreditSpecificationRequest
  ): zio.aws.ec2.model.ModifyInstanceCreditSpecificationRequest.ReadOnly =
    new Wrapper(impl)
}
