package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait LaunchTemplateAutoRecoveryState {
  def unwrap: software.amazon.awssdk.services.ec2.model.LaunchTemplateAutoRecoveryState
}
object LaunchTemplateAutoRecoveryState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.LaunchTemplateAutoRecoveryState
  ): zio.aws.ec2.model.LaunchTemplateAutoRecoveryState = value match {
    case software.amazon.awssdk.services.ec2.model.LaunchTemplateAutoRecoveryState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.LaunchTemplateAutoRecoveryState.DEFAULT =>
      val r = default
      r
    case software.amazon.awssdk.services.ec2.model.LaunchTemplateAutoRecoveryState.DISABLED =>
      val r = disabled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.LaunchTemplateAutoRecoveryState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LaunchTemplateAutoRecoveryState =
      software.amazon.awssdk.services.ec2.model.LaunchTemplateAutoRecoveryState.UNKNOWN_TO_SDK_VERSION
  }
  case object default
      extends zio.aws.ec2.model.LaunchTemplateAutoRecoveryState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LaunchTemplateAutoRecoveryState =
      software.amazon.awssdk.services.ec2.model.LaunchTemplateAutoRecoveryState.DEFAULT
  }
  case object disabled
      extends zio.aws.ec2.model.LaunchTemplateAutoRecoveryState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LaunchTemplateAutoRecoveryState =
      software.amazon.awssdk.services.ec2.model.LaunchTemplateAutoRecoveryState.DISABLED
  }
}
