package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait IpamScopeState {
  def unwrap: software.amazon.awssdk.services.ec2.model.IpamScopeState
}
object IpamScopeState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.IpamScopeState
  ): zio.aws.ec2.model.IpamScopeState = value match {
    case software.amazon.awssdk.services.ec2.model.IpamScopeState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.IpamScopeState.CREATE_IN_PROGRESS =>
      val r = `create-in-progress`
      r
    case software.amazon.awssdk.services.ec2.model.IpamScopeState.CREATE_COMPLETE =>
      val r = `create-complete`
      r
    case software.amazon.awssdk.services.ec2.model.IpamScopeState.CREATE_FAILED =>
      val r = `create-failed`
      r
    case software.amazon.awssdk.services.ec2.model.IpamScopeState.MODIFY_IN_PROGRESS =>
      val r = `modify-in-progress`
      r
    case software.amazon.awssdk.services.ec2.model.IpamScopeState.MODIFY_COMPLETE =>
      val r = `modify-complete`
      r
    case software.amazon.awssdk.services.ec2.model.IpamScopeState.MODIFY_FAILED =>
      val r = `modify-failed`
      r
    case software.amazon.awssdk.services.ec2.model.IpamScopeState.DELETE_IN_PROGRESS =>
      val r = `delete-in-progress`
      r
    case software.amazon.awssdk.services.ec2.model.IpamScopeState.DELETE_COMPLETE =>
      val r = `delete-complete`
      r
    case software.amazon.awssdk.services.ec2.model.IpamScopeState.DELETE_FAILED =>
      val r = `delete-failed`
      r
    case software.amazon.awssdk.services.ec2.model.IpamScopeState.ISOLATE_IN_PROGRESS =>
      val r = `isolate-in-progress`
      r
    case software.amazon.awssdk.services.ec2.model.IpamScopeState.ISOLATE_COMPLETE =>
      val r = `isolate-complete`
      r
    case software.amazon.awssdk.services.ec2.model.IpamScopeState.RESTORE_IN_PROGRESS =>
      val r = `restore-in-progress`
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.IpamScopeState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamScopeState =
      software.amazon.awssdk.services.ec2.model.IpamScopeState.UNKNOWN_TO_SDK_VERSION
  }
  case object `create-in-progress` extends zio.aws.ec2.model.IpamScopeState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamScopeState =
      software.amazon.awssdk.services.ec2.model.IpamScopeState.CREATE_IN_PROGRESS
  }
  case object `create-complete` extends zio.aws.ec2.model.IpamScopeState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamScopeState =
      software.amazon.awssdk.services.ec2.model.IpamScopeState.CREATE_COMPLETE
  }
  case object `create-failed` extends zio.aws.ec2.model.IpamScopeState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamScopeState =
      software.amazon.awssdk.services.ec2.model.IpamScopeState.CREATE_FAILED
  }
  case object `modify-in-progress` extends zio.aws.ec2.model.IpamScopeState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamScopeState =
      software.amazon.awssdk.services.ec2.model.IpamScopeState.MODIFY_IN_PROGRESS
  }
  case object `modify-complete` extends zio.aws.ec2.model.IpamScopeState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamScopeState =
      software.amazon.awssdk.services.ec2.model.IpamScopeState.MODIFY_COMPLETE
  }
  case object `modify-failed` extends zio.aws.ec2.model.IpamScopeState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamScopeState =
      software.amazon.awssdk.services.ec2.model.IpamScopeState.MODIFY_FAILED
  }
  case object `delete-in-progress` extends zio.aws.ec2.model.IpamScopeState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamScopeState =
      software.amazon.awssdk.services.ec2.model.IpamScopeState.DELETE_IN_PROGRESS
  }
  case object `delete-complete` extends zio.aws.ec2.model.IpamScopeState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamScopeState =
      software.amazon.awssdk.services.ec2.model.IpamScopeState.DELETE_COMPLETE
  }
  case object `delete-failed` extends zio.aws.ec2.model.IpamScopeState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamScopeState =
      software.amazon.awssdk.services.ec2.model.IpamScopeState.DELETE_FAILED
  }
  case object `isolate-in-progress` extends zio.aws.ec2.model.IpamScopeState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamScopeState =
      software.amazon.awssdk.services.ec2.model.IpamScopeState.ISOLATE_IN_PROGRESS
  }
  case object `isolate-complete` extends zio.aws.ec2.model.IpamScopeState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamScopeState =
      software.amazon.awssdk.services.ec2.model.IpamScopeState.ISOLATE_COMPLETE
  }
  case object `restore-in-progress` extends zio.aws.ec2.model.IpamScopeState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamScopeState =
      software.amazon.awssdk.services.ec2.model.IpamScopeState.RESTORE_IN_PROGRESS
  }
}
