package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceStatus(
    availabilityZone: Optional[String] = Optional.Absent,
    outpostArn: Optional[String] = Optional.Absent,
    events: Optional[Iterable[zio.aws.ec2.model.InstanceStatusEvent]] =
      Optional.Absent,
    instanceId: Optional[String] = Optional.Absent,
    instanceState: Optional[zio.aws.ec2.model.InstanceState] = Optional.Absent,
    instanceStatus: Optional[zio.aws.ec2.model.InstanceStatusSummary] =
      Optional.Absent,
    systemStatus: Optional[zio.aws.ec2.model.InstanceStatusSummary] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceStatus = {
    import InstanceStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceStatus
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(outpostArn.map(value => value: java.lang.String))(
        _.outpostArn
      )
      .optionallyWith(
        events.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.events)
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(instanceState.map(value => value.buildAwsValue()))(
        _.instanceState
      )
      .optionallyWith(instanceStatus.map(value => value.buildAwsValue()))(
        _.instanceStatus
      )
      .optionallyWith(systemStatus.map(value => value.buildAwsValue()))(
        _.systemStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceStatus.ReadOnly =
    zio.aws.ec2.model.InstanceStatus.wrap(buildAwsValue())
}
object InstanceStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceStatus =
      zio.aws.ec2.model.InstanceStatus(
        availabilityZone.map(value => value),
        outpostArn.map(value => value),
        events.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instanceId.map(value => value),
        instanceState.map(value => value.asEditable),
        instanceStatus.map(value => value.asEditable),
        systemStatus.map(value => value.asEditable)
      )
    def availabilityZone: Optional[String]
    def outpostArn: Optional[String]
    def events: Optional[List[zio.aws.ec2.model.InstanceStatusEvent.ReadOnly]]
    def instanceId: Optional[String]
    def instanceState: Optional[zio.aws.ec2.model.InstanceState.ReadOnly]
    def instanceStatus
        : Optional[zio.aws.ec2.model.InstanceStatusSummary.ReadOnly]
    def systemStatus: Optional[zio.aws.ec2.model.InstanceStatusSummary.ReadOnly]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
    def getEvents: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceStatusEvent.ReadOnly
    ]] = AwsError.unwrapOptionField("events", events)
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getInstanceState
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceState.ReadOnly] =
      AwsError.unwrapOptionField("instanceState", instanceState)
    def getInstanceStatus
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceStatusSummary.ReadOnly] =
      AwsError.unwrapOptionField("instanceStatus", instanceStatus)
    def getSystemStatus
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceStatusSummary.ReadOnly] =
      AwsError.unwrapOptionField("systemStatus", systemStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceStatus
  ) extends zio.aws.ec2.model.InstanceStatus.ReadOnly {
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val outpostArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.outpostArn())
      .map(value => value: String)
    override val events
        : Optional[List[zio.aws.ec2.model.InstanceStatusEvent.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.events())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.InstanceStatusEvent.wrap(item)
          }.toList
        )
    override val instanceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => value: String)
    override val instanceState
        : Optional[zio.aws.ec2.model.InstanceState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceState())
        .map(value => zio.aws.ec2.model.InstanceState.wrap(value))
    override val instanceStatus
        : Optional[zio.aws.ec2.model.InstanceStatusSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceStatus())
        .map(value => zio.aws.ec2.model.InstanceStatusSummary.wrap(value))
    override val systemStatus
        : Optional[zio.aws.ec2.model.InstanceStatusSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.systemStatus())
        .map(value => zio.aws.ec2.model.InstanceStatusSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceStatus
  ): zio.aws.ec2.model.InstanceStatus.ReadOnly = new Wrapper(impl)
}
