package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstancePrivateIpAddress(
    association: Optional[
      zio.aws.ec2.model.InstanceNetworkInterfaceAssociation
    ] = Optional.Absent,
    primary: Optional[Boolean] = Optional.Absent,
    privateDnsName: Optional[String] = Optional.Absent,
    privateIpAddress: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstancePrivateIpAddress = {
    import InstancePrivateIpAddress.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstancePrivateIpAddress
      .builder()
      .optionallyWith(association.map(value => value.buildAwsValue()))(
        _.association
      )
      .optionallyWith(primary.map(value => value: java.lang.Boolean))(_.primary)
      .optionallyWith(privateDnsName.map(value => value: java.lang.String))(
        _.privateDnsName
      )
      .optionallyWith(privateIpAddress.map(value => value: java.lang.String))(
        _.privateIpAddress
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstancePrivateIpAddress.ReadOnly =
    zio.aws.ec2.model.InstancePrivateIpAddress.wrap(buildAwsValue())
}
object InstancePrivateIpAddress {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstancePrivateIpAddress
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstancePrivateIpAddress =
      zio.aws.ec2.model.InstancePrivateIpAddress(
        association.map(value => value.asEditable),
        primary.map(value => value),
        privateDnsName.map(value => value),
        privateIpAddress.map(value => value)
      )
    def association: Optional[
      zio.aws.ec2.model.InstanceNetworkInterfaceAssociation.ReadOnly
    ]
    def primary: Optional[Boolean]
    def privateDnsName: Optional[String]
    def privateIpAddress: Optional[String]
    def getAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.InstanceNetworkInterfaceAssociation.ReadOnly
    ] = AwsError.unwrapOptionField("association", association)
    def getPrimary: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("primary", primary)
    def getPrivateDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateDnsName", privateDnsName)
    def getPrivateIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstancePrivateIpAddress
  ) extends zio.aws.ec2.model.InstancePrivateIpAddress.ReadOnly {
    override val association: Optional[
      zio.aws.ec2.model.InstanceNetworkInterfaceAssociation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.association())
      .map(value =>
        zio.aws.ec2.model.InstanceNetworkInterfaceAssociation.wrap(value)
      )
    override val primary: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.primary())
      .map(value => value: Boolean)
    override val privateDnsName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.privateDnsName())
      .map(value => value: String)
    override val privateIpAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.privateIpAddress())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstancePrivateIpAddress
  ): zio.aws.ec2.model.InstancePrivateIpAddress.ReadOnly = new Wrapper(impl)
}
