package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{Integer, MillisecondDateTime}
import scala.jdk.CollectionConverters._
final case class GetAwsNetworkPerformanceDataRequest(
    dataQueries: Optional[Iterable[zio.aws.ec2.model.DataQuery]] =
      Optional.Absent,
    startTime: Optional[MillisecondDateTime] = Optional.Absent,
    endTime: Optional[MillisecondDateTime] = Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetAwsNetworkPerformanceDataRequest = {
    import GetAwsNetworkPerformanceDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetAwsNetworkPerformanceDataRequest
      .builder()
      .optionallyWith(
        dataQueries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataQueries)
      .optionallyWith(
        startTime.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(
        endTime.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.endTime)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetAwsNetworkPerformanceDataRequest.ReadOnly =
    zio.aws.ec2.model.GetAwsNetworkPerformanceDataRequest.wrap(buildAwsValue())
}
object GetAwsNetworkPerformanceDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetAwsNetworkPerformanceDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetAwsNetworkPerformanceDataRequest =
      zio.aws.ec2.model.GetAwsNetworkPerformanceDataRequest(
        dataQueries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        startTime.map(value => value),
        endTime.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def dataQueries: Optional[List[zio.aws.ec2.model.DataQuery.ReadOnly]]
    def startTime: Optional[MillisecondDateTime]
    def endTime: Optional[MillisecondDateTime]
    def maxResults: Optional[Integer]
    def nextToken: Optional[String]
    def getDataQueries
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.DataQuery.ReadOnly]] =
      AwsError.unwrapOptionField("dataQueries", dataQueries)
    def getStartTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetAwsNetworkPerformanceDataRequest
  ) extends zio.aws.ec2.model.GetAwsNetworkPerformanceDataRequest.ReadOnly {
    override val dataQueries
        : Optional[List[zio.aws.ec2.model.DataQuery.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataQueries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.DataQuery.wrap(item)
          }.toList
        )
    override val startTime: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startTime())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val endTime: Optional[MillisecondDateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetAwsNetworkPerformanceDataRequest
  ): zio.aws.ec2.model.GetAwsNetworkPerformanceDataRequest.ReadOnly =
    new Wrapper(impl)
}
