package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EnaSrdUdpSpecification(
    enaSrdUdpEnabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EnaSrdUdpSpecification = {
    import EnaSrdUdpSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EnaSrdUdpSpecification
      .builder()
      .optionallyWith(enaSrdUdpEnabled.map(value => value: java.lang.Boolean))(
        _.enaSrdUdpEnabled
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.EnaSrdUdpSpecification.ReadOnly =
    zio.aws.ec2.model.EnaSrdUdpSpecification.wrap(buildAwsValue())
}
object EnaSrdUdpSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EnaSrdUdpSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EnaSrdUdpSpecification = zio.aws.ec2.model
      .EnaSrdUdpSpecification(enaSrdUdpEnabled.map(value => value))
    def enaSrdUdpEnabled: Optional[Boolean]
    def getEnaSrdUdpEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enaSrdUdpEnabled", enaSrdUdpEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EnaSrdUdpSpecification
  ) extends zio.aws.ec2.model.EnaSrdUdpSpecification.ReadOnly {
    override val enaSrdUdpEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enaSrdUdpEnabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EnaSrdUdpSpecification
  ): zio.aws.ec2.model.EnaSrdUdpSpecification.ReadOnly = new Wrapper(impl)
}
