package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeTransitGatewayPolicyTablesResponse(
    transitGatewayPolicyTables: Optional[
      Iterable[zio.aws.ec2.model.TransitGatewayPolicyTable]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayPolicyTablesResponse = {
    import DescribeTransitGatewayPolicyTablesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayPolicyTablesResponse
      .builder()
      .optionallyWith(
        transitGatewayPolicyTables.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.transitGatewayPolicyTables)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeTransitGatewayPolicyTablesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeTransitGatewayPolicyTablesResponse
      .wrap(buildAwsValue())
}
object DescribeTransitGatewayPolicyTablesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayPolicyTablesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeTransitGatewayPolicyTablesResponse =
      zio.aws.ec2.model.DescribeTransitGatewayPolicyTablesResponse(
        transitGatewayPolicyTables.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def transitGatewayPolicyTables
        : Optional[List[zio.aws.ec2.model.TransitGatewayPolicyTable.ReadOnly]]
    def nextToken: Optional[String]
    def getTransitGatewayPolicyTables: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TransitGatewayPolicyTable.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "transitGatewayPolicyTables",
      transitGatewayPolicyTables
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayPolicyTablesResponse
  ) extends zio.aws.ec2.model.DescribeTransitGatewayPolicyTablesResponse.ReadOnly {
    override val transitGatewayPolicyTables
        : Optional[List[zio.aws.ec2.model.TransitGatewayPolicyTable.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayPolicyTables())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TransitGatewayPolicyTable.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayPolicyTablesResponse
  ): zio.aws.ec2.model.DescribeTransitGatewayPolicyTablesResponse.ReadOnly =
    new Wrapper(impl)
}
