package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeTrafficMirrorFiltersResponse(
    trafficMirrorFilters: Optional[
      Iterable[zio.aws.ec2.model.TrafficMirrorFilter]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorFiltersResponse = {
    import DescribeTrafficMirrorFiltersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorFiltersResponse
      .builder()
      .optionallyWith(
        trafficMirrorFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.trafficMirrorFilters)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeTrafficMirrorFiltersResponse.ReadOnly =
    zio.aws.ec2.model.DescribeTrafficMirrorFiltersResponse.wrap(buildAwsValue())
}
object DescribeTrafficMirrorFiltersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorFiltersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeTrafficMirrorFiltersResponse =
      zio.aws.ec2.model.DescribeTrafficMirrorFiltersResponse(
        trafficMirrorFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def trafficMirrorFilters
        : Optional[List[zio.aws.ec2.model.TrafficMirrorFilter.ReadOnly]]
    def nextToken: Optional[String]
    def getTrafficMirrorFilters: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TrafficMirrorFilter.ReadOnly
    ]] =
      AwsError.unwrapOptionField("trafficMirrorFilters", trafficMirrorFilters)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorFiltersResponse
  ) extends zio.aws.ec2.model.DescribeTrafficMirrorFiltersResponse.ReadOnly {
    override val trafficMirrorFilters
        : Optional[List[zio.aws.ec2.model.TrafficMirrorFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trafficMirrorFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TrafficMirrorFilter.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorFiltersResponse
  ): zio.aws.ec2.model.DescribeTrafficMirrorFiltersResponse.ReadOnly =
    new Wrapper(impl)
}
