package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeFleetsInstances(
    launchTemplateAndOverrides: Optional[
      zio.aws.ec2.model.LaunchTemplateAndOverridesResponse
    ] = Optional.Absent,
    lifecycle: Optional[zio.aws.ec2.model.InstanceLifecycle] = Optional.Absent,
    instanceIds: Optional[Iterable[InstanceId]] = Optional.Absent,
    instanceType: Optional[zio.aws.ec2.model.InstanceType] = Optional.Absent,
    platform: Optional[zio.aws.ec2.model.PlatformValues] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeFleetsInstances = {
    import DescribeFleetsInstances.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeFleetsInstances
      .builder()
      .optionallyWith(
        launchTemplateAndOverrides.map(value => value.buildAwsValue())
      )(_.launchTemplateAndOverrides)
      .optionallyWith(lifecycle.map(value => value.unwrap))(_.lifecycle)
      .optionallyWith(
        instanceIds.map(value =>
          value.map { item =>
            InstanceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.instanceIds)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeFleetsInstances.ReadOnly =
    zio.aws.ec2.model.DescribeFleetsInstances.wrap(buildAwsValue())
}
object DescribeFleetsInstances {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeFleetsInstances
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeFleetsInstances =
      zio.aws.ec2.model.DescribeFleetsInstances(
        launchTemplateAndOverrides.map(value => value.asEditable),
        lifecycle.map(value => value),
        instanceIds.map(value => value),
        instanceType.map(value => value),
        platform.map(value => value)
      )
    def launchTemplateAndOverrides: Optional[
      zio.aws.ec2.model.LaunchTemplateAndOverridesResponse.ReadOnly
    ]
    def lifecycle: Optional[zio.aws.ec2.model.InstanceLifecycle]
    def instanceIds: Optional[List[InstanceId]]
    def instanceType: Optional[zio.aws.ec2.model.InstanceType]
    def platform: Optional[zio.aws.ec2.model.PlatformValues]
    def getLaunchTemplateAndOverrides: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateAndOverridesResponse.ReadOnly
    ] = AwsError.unwrapOptionField(
      "launchTemplateAndOverrides",
      launchTemplateAndOverrides
    )
    def getLifecycle: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceLifecycle] =
      AwsError.unwrapOptionField("lifecycle", lifecycle)
    def getInstanceIds: ZIO[Any, AwsError, List[InstanceId]] =
      AwsError.unwrapOptionField("instanceIds", instanceIds)
    def getInstanceType: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getPlatform: ZIO[Any, AwsError, zio.aws.ec2.model.PlatformValues] =
      AwsError.unwrapOptionField("platform", platform)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFleetsInstances
  ) extends zio.aws.ec2.model.DescribeFleetsInstances.ReadOnly {
    override val launchTemplateAndOverrides: Optional[
      zio.aws.ec2.model.LaunchTemplateAndOverridesResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.launchTemplateAndOverrides())
      .map(value =>
        zio.aws.ec2.model.LaunchTemplateAndOverridesResponse.wrap(value)
      )
    override val lifecycle: Optional[zio.aws.ec2.model.InstanceLifecycle] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycle())
        .map(value => zio.aws.ec2.model.InstanceLifecycle.wrap(value))
    override val instanceIds: Optional[List[InstanceId]] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.InstanceId(item)
        }.toList
      )
    override val instanceType: Optional[zio.aws.ec2.model.InstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value => zio.aws.ec2.model.InstanceType.wrap(value))
    override val platform: Optional[zio.aws.ec2.model.PlatformValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platform())
        .map(value => zio.aws.ec2.model.PlatformValues.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFleetsInstances
  ): zio.aws.ec2.model.DescribeFleetsInstances.ReadOnly = new Wrapper(impl)
}
