package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteCoipPoolResponse(
    coipPool: Optional[zio.aws.ec2.model.CoipPool] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteCoipPoolResponse = {
    import DeleteCoipPoolResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteCoipPoolResponse
      .builder()
      .optionallyWith(coipPool.map(value => value.buildAwsValue()))(_.coipPool)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteCoipPoolResponse.ReadOnly =
    zio.aws.ec2.model.DeleteCoipPoolResponse.wrap(buildAwsValue())
}
object DeleteCoipPoolResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteCoipPoolResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteCoipPoolResponse = zio.aws.ec2.model
      .DeleteCoipPoolResponse(coipPool.map(value => value.asEditable))
    def coipPool: Optional[zio.aws.ec2.model.CoipPool.ReadOnly]
    def getCoipPool: ZIO[Any, AwsError, zio.aws.ec2.model.CoipPool.ReadOnly] =
      AwsError.unwrapOptionField("coipPool", coipPool)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteCoipPoolResponse
  ) extends zio.aws.ec2.model.DeleteCoipPoolResponse.ReadOnly {
    override val coipPool: Optional[zio.aws.ec2.model.CoipPool.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.coipPool())
        .map(value => zio.aws.ec2.model.CoipPool.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteCoipPoolResponse
  ): zio.aws.ec2.model.DeleteCoipPoolResponse.ReadOnly = new Wrapper(impl)
}
