package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateTransitGatewayPeeringAttachmentRequestOptions(
    dynamicRouting: Optional[zio.aws.ec2.model.DynamicRoutingValue] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPeeringAttachmentRequestOptions = {
    import CreateTransitGatewayPeeringAttachmentRequestOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPeeringAttachmentRequestOptions
      .builder()
      .optionallyWith(dynamicRouting.map(value => value.unwrap))(
        _.dynamicRouting
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateTransitGatewayPeeringAttachmentRequestOptions.ReadOnly =
    zio.aws.ec2.model.CreateTransitGatewayPeeringAttachmentRequestOptions
      .wrap(buildAwsValue())
}
object CreateTransitGatewayPeeringAttachmentRequestOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPeeringAttachmentRequestOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.CreateTransitGatewayPeeringAttachmentRequestOptions =
      zio.aws.ec2.model.CreateTransitGatewayPeeringAttachmentRequestOptions(
        dynamicRouting.map(value => value)
      )
    def dynamicRouting: Optional[zio.aws.ec2.model.DynamicRoutingValue]
    def getDynamicRouting
        : ZIO[Any, AwsError, zio.aws.ec2.model.DynamicRoutingValue] =
      AwsError.unwrapOptionField("dynamicRouting", dynamicRouting)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPeeringAttachmentRequestOptions
  ) extends zio.aws.ec2.model.CreateTransitGatewayPeeringAttachmentRequestOptions.ReadOnly {
    override val dynamicRouting
        : Optional[zio.aws.ec2.model.DynamicRoutingValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dynamicRouting())
        .map(value => zio.aws.ec2.model.DynamicRoutingValue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPeeringAttachmentRequestOptions
  ): zio.aws.ec2.model.CreateTransitGatewayPeeringAttachmentRequestOptions.ReadOnly =
    new Wrapper(impl)
}
