package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDefaultSubnetRequest(
    availabilityZone: String,
    ipv6Native: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateDefaultSubnetRequest = {
    import CreateDefaultSubnetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateDefaultSubnetRequest
      .builder()
      .availabilityZone(availabilityZone: java.lang.String)
      .optionallyWith(ipv6Native.map(value => value: java.lang.Boolean))(
        _.ipv6Native
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateDefaultSubnetRequest.ReadOnly =
    zio.aws.ec2.model.CreateDefaultSubnetRequest.wrap(buildAwsValue())
}
object CreateDefaultSubnetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateDefaultSubnetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateDefaultSubnetRequest =
      zio.aws.ec2.model.CreateDefaultSubnetRequest(
        availabilityZone,
        ipv6Native.map(value => value)
      )
    def availabilityZone: String
    def ipv6Native: Optional[Boolean]
    def getAvailabilityZone: ZIO[Any, Nothing, String] =
      ZIO.succeed(availabilityZone)
    def getIpv6Native: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ipv6Native", ipv6Native)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateDefaultSubnetRequest
  ) extends zio.aws.ec2.model.CreateDefaultSubnetRequest.ReadOnly {
    override val availabilityZone: String = impl.availabilityZone(): String
    override val ipv6Native: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6Native())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateDefaultSubnetRequest
  ): zio.aws.ec2.model.CreateDefaultSubnetRequest.ReadOnly = new Wrapper(impl)
}
