package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CpuOptions(
    coreCount: Optional[Integer] = Optional.Absent,
    threadsPerCore: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.CpuOptions = {
    import CpuOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CpuOptions
      .builder()
      .optionallyWith(coreCount.map(value => value: java.lang.Integer))(
        _.coreCount
      )
      .optionallyWith(threadsPerCore.map(value => value: java.lang.Integer))(
        _.threadsPerCore
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CpuOptions.ReadOnly =
    zio.aws.ec2.model.CpuOptions.wrap(buildAwsValue())
}
object CpuOptions {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.CpuOptions] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CpuOptions = zio.aws.ec2.model.CpuOptions(
      coreCount.map(value => value),
      threadsPerCore.map(value => value)
    )
    def coreCount: Optional[Integer]
    def threadsPerCore: Optional[Integer]
    def getCoreCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("coreCount", coreCount)
    def getThreadsPerCore: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("threadsPerCore", threadsPerCore)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CpuOptions
  ) extends zio.aws.ec2.model.CpuOptions.ReadOnly {
    override val coreCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.coreCount())
      .map(value => value: Integer)
    override val threadsPerCore: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.threadsPerCore())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CpuOptions
  ): zio.aws.ec2.model.CpuOptions.ReadOnly = new Wrapper(impl)
}
