package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CopyFpgaImageResponse(
    fpgaImageId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CopyFpgaImageResponse = {
    import CopyFpgaImageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CopyFpgaImageResponse
      .builder()
      .optionallyWith(fpgaImageId.map(value => value: java.lang.String))(
        _.fpgaImageId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CopyFpgaImageResponse.ReadOnly =
    zio.aws.ec2.model.CopyFpgaImageResponse.wrap(buildAwsValue())
}
object CopyFpgaImageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CopyFpgaImageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CopyFpgaImageResponse =
      zio.aws.ec2.model.CopyFpgaImageResponse(fpgaImageId.map(value => value))
    def fpgaImageId: Optional[String]
    def getFpgaImageId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fpgaImageId", fpgaImageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CopyFpgaImageResponse
  ) extends zio.aws.ec2.model.CopyFpgaImageResponse.ReadOnly {
    override val fpgaImageId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.fpgaImageId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CopyFpgaImageResponse
  ): zio.aws.ec2.model.CopyFpgaImageResponse.ReadOnly = new Wrapper(impl)
}
