package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait VpnProtocol {
  def unwrap: software.amazon.awssdk.services.ec2.model.VpnProtocol
}
object VpnProtocol {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.VpnProtocol
  ): zio.aws.ec2.model.VpnProtocol = value match {
    case software.amazon.awssdk.services.ec2.model.VpnProtocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.VpnProtocol.OPENVPN =>
      val r = openvpn
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.VpnProtocol {
    override def unwrap: software.amazon.awssdk.services.ec2.model.VpnProtocol =
      software.amazon.awssdk.services.ec2.model.VpnProtocol.UNKNOWN_TO_SDK_VERSION
  }
  case object openvpn extends zio.aws.ec2.model.VpnProtocol {
    override def unwrap: software.amazon.awssdk.services.ec2.model.VpnProtocol =
      software.amazon.awssdk.services.ec2.model.VpnProtocol.OPENVPN
  }
}
